/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class RepositoryPropertiesIndexRequest {
    private final Date recentActivity;
    private final Repository repository;
    private final Long size;

    private RepositoryPropertiesIndexRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.recentActivity = builder.recentActivity;
        this.size = builder.size;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryPropertiesIndexRequest that = (RepositoryPropertiesIndexRequest)o;
        return Objects.equals(this.recentActivity, that.recentActivity) && this.repository.equals((Object)that.repository) && Objects.equals(this.size, that.size);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public Date getRecentActivity() {
        return this.recentActivity;
    }

    @Nullable
    public Long getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hash(this.recentActivity, this.repository, this.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("repository", (Object)this.repository).add("recentActivity", (Object)this.recentActivity).add("size", (Object)this.size).toString();
    }

    public static final class Builder {
        private Date recentActivity;
        private Repository repository;
        private Long size;

        private Builder() {
        }

        @Nonnull
        public RepositoryPropertiesIndexRequest build() {
            return new RepositoryPropertiesIndexRequest(this);
        }

        @Nonnull
        public Builder recentActivity(@Nullable Date recentActivity) {
            this.recentActivity = recentActivity;
            return this;
        }

        @Nonnull
        public Builder repository(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            return this;
        }

        @Nonnull
        public Builder size(@Nullable Long size) {
            this.size = size;
            return this;
        }
    }
}

