/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RequestStatistics {
    private final List<String> failedDocumentIds;
    private final int numDocumentActions;
    private final int numFailedRequests;
    private final int numPartiallyFailedRequests;
    private final int numRequests;
    private final Duration time;

    protected RequestStatistics(Builder builder) {
        this.failedDocumentIds = builder.failedDocumentIds;
        this.numRequests = builder.numRequests;
        this.numDocumentActions = builder.numDocumentActions;
        this.numFailedRequests = builder.numFailedRequests;
        this.numPartiallyFailedRequests = builder.numPartiallyFailedRequests;
        this.time = builder.time;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public List<String> getFailedDocumentIds() {
        return this.failedDocumentIds;
    }

    public int getNumDocumentActions() {
        return this.numDocumentActions;
    }

    public int getNumFailedRequests() {
        return this.numFailedRequests;
    }

    public int getNumPartiallyFailedRequests() {
        return this.numPartiallyFailedRequests;
    }

    public int getNumRequests() {
        return this.numRequests;
    }

    public Duration getTime() {
        if (this.time == null) {
            return Duration.ZERO;
        }
        return this.time;
    }

    public boolean hasErrors() {
        return this.numFailedRequests > 0 || this.numPartiallyFailedRequests > 0;
    }

    public String toString() {
        return "RequestStatistics{failedDocumentIds=" + String.valueOf(this.failedDocumentIds) + ", numRequests=" + this.numRequests + ", numDocumentActions=" + this.numDocumentActions + ", numFailedRequests=" + this.numFailedRequests + ", numPartiallyFailedRequests=" + this.numPartiallyFailedRequests + ", time=" + this.time.toMillis() + " ms}";
    }

    public static class Builder {
        private final List<String> failedDocumentIds = new ArrayList<String>();
        private int numDocumentActions;
        private int numFailedRequests;
        private int numPartiallyFailedRequests;
        private int numRequests;
        private Duration time = Duration.ZERO;

        Builder() {
        }

        @Nonnull
        public Builder add(RequestStatistics statistics) {
            this.numRequests += statistics.numRequests;
            this.numDocumentActions += statistics.numDocumentActions;
            this.numFailedRequests += statistics.numFailedRequests;
            this.numPartiallyFailedRequests += statistics.numPartiallyFailedRequests;
            this.incrementTime(statistics.time);
            return this;
        }

        @Nonnull
        public Builder addFailedDocumentId(@Nonnull String documentId) {
            this.failedDocumentIds.add(Objects.requireNonNull(documentId, "documentId"));
            return this;
        }

        @Nonnull
        public RequestStatistics build() {
            return new RequestStatistics(this);
        }

        @Nonnull
        public Builder incrementNumDocumentActions(int delta) {
            this.numDocumentActions += delta;
            return this;
        }

        @Nonnull
        public Builder incrementNumFailedRequests() {
            ++this.numFailedRequests;
            return this;
        }

        @Nonnull
        public Builder incrementNumPartiallyFailedRequests() {
            ++this.numPartiallyFailedRequests;
            return this;
        }

        @Nonnull
        public Builder incrementNumRequests() {
            ++this.numRequests;
            return this;
        }

        @Nonnull
        public Builder incrementTime(@Nonnull Duration value) {
            this.time = this.time.plus(Objects.requireNonNull(value, "incrementIndexTime(indexTime)"));
            return this;
        }

        @Nonnull
        public Builder time(@Nonnull Duration time) {
            this.time = Objects.requireNonNull(time, "time");
            return this;
        }
    }
}

