/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.indexer;

import com.atlassian.bitbucket.internal.search.indexing.indexer.RequestStatistics;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class UpdateResult {
    private final RequestStatistics requestStatistics;

    private UpdateResult(Builder builder) {
        this.requestStatistics = Objects.requireNonNull(builder.requestStatistics, "requestStatistics");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public RequestStatistics getRequestStatistics() {
        return this.requestStatistics;
    }

    public String toString() {
        return "UpdateResult{requestStatistics=" + String.valueOf(this.requestStatistics) + "}";
    }

    public static class Builder {
        private RequestStatistics requestStatistics = RequestStatistics.builder().build();

        private Builder() {
        }

        @Nonnull
        public Builder add(@Nonnull UpdateResult that) {
            RequestStatistics.Builder builder = RequestStatistics.builder();
            builder.add(this.requestStatistics);
            builder.add(Objects.requireNonNull(that, (String)"that").requestStatistics);
            this.requestStatistics = builder.build();
            return this;
        }

        @Nonnull
        public UpdateResult build() {
            return new UpdateResult(this);
        }

        @Nonnull
        public Builder requestStatistics(@Nonnull RequestStatistics value) {
            this.requestStatistics = Objects.requireNonNull(value, "requestStatistics");
            return this;
        }
    }
}

