/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.jobs;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.common.cluster.Job;
import com.atlassian.bitbucket.internal.search.indexing.IndexingSynchronizationService;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchSynchronizeJob")
public class SearchSynchronizeJob
implements Job,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(IndexingSynchronizationService.class);
    private final ClusterJobManager clusterJobManager;
    private final IndexEventQueueProcessor indexEventQueueProcessor;
    private final IndexingSynchronizationService indexingSynchronizationService;

    @Autowired
    public SearchSynchronizeJob(ClusterJobManager clusterJobManager, IndexEventQueueProcessor indexEventQueueProcessor, IndexingSynchronizationService indexingSynchronizationService) {
        this.clusterJobManager = clusterJobManager;
        this.indexEventQueueProcessor = indexEventQueueProcessor;
        this.indexingSynchronizationService = indexingSynchronizationService;
    }

    @Override
    public boolean isStartupJob() {
        return false;
    }

    public void onStart() {
        this.clusterJobManager.registerJob(this);
    }

    public void onStop() {
        this.clusterJobManager.removeAllJobsOfType(this.getClass());
    }

    @Override
    public boolean run() {
        this.indexEventQueueProcessor.clear();
        log.info("Beginning indexing of all projects and repositories for search.");
        return this.indexingSynchronizationService.synchronizeStores();
    }
}

