/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.jobs;

import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.common.cluster.Job;
import com.atlassian.bitbucket.internal.search.common.cluster.RetryPolicy;
import com.atlassian.bitbucket.internal.search.indexing.IndexingSynchronizationService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="startupChecksJob")
public class StartupChecksJob
implements Job,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(StartupChecksJob.class);
    private final ClusterJobManager clusterJobManager;
    private final IndexingSynchronizationService synchronizationService;

    @Autowired
    public StartupChecksJob(IndexingSynchronizationService synchronizationService, ClusterJobManager clusterJobManager) {
        this.synchronizationService = synchronizationService;
        this.clusterJobManager = clusterJobManager;
    }

    @Override
    @Nonnull
    public RetryPolicy getRetryPolicy() {
        return RetryPolicy.UNLIMITED;
    }

    @Override
    public boolean isStartupJob() {
        return true;
    }

    public void onStart() {
        this.clusterJobManager.registerJob(this);
    }

    public void onStop() {
        this.clusterJobManager.removeAllJobsOfType(this.getClass());
    }

    @Override
    public boolean run() {
        log.info("Running startup jobs for search");
        return this.synchronizationService.synchronizeStores();
    }
}

