/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.jobs.checks;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckRegistry;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckResult;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.SearchHealthCheck;
import com.atlassian.bitbucket.internal.search.common.mapping.Index;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexingSettings;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import com.atlassian.elasticsearch.client.search.SearchRequestBuilder;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.annotation.Nonnull;
import java.net.ConnectException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="knownIssueCheck")
public class KnownIssueCheck
implements SearchHealthCheck,
LifecycleAware {
    private static final String SETTING_PREFIX = "search-index-check-ran-";
    private static final int WEIGHT = 300;
    private static final Logger log = LoggerFactory.getLogger(KnownIssueCheck.class);
    private final HealthCheckRegistry healthCheckRegistry;
    private final IndexingSettings indexingSettings;
    private final PluginSettings pluginSettings;
    private final IndexEventQueueProcessor processor;
    private final SearchClient searchClient;

    @Autowired
    public KnownIssueCheck(SearchClient searchClient, HealthCheckRegistry healthCheckRegistry, IndexingSettings indexingSettings, IndexEventQueueProcessor processor, PluginSettingsFactory pluginSettingsFactory) {
        this.searchClient = searchClient;
        this.healthCheckRegistry = healthCheckRegistry;
        this.indexingSettings = indexingSettings;
        this.processor = processor;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("bitbucket-search-checks");
    }

    @Override
    public int getWeight() {
        return 300;
    }

    @Override
    @Nonnull
    public HealthCheckResult manageFailure() {
        this.healthCheckRegistry.unregisterHealthCheck(this);
        return HealthCheckResult.RESOLVED;
    }

    public void onStart() {
        this.healthCheckRegistry.registerHealthCheck(this);
    }

    public void onStop() {
        this.healthCheckRegistry.unregisterHealthCheck(this);
    }

    @Override
    public boolean test() {
        return this.repairUnknownChangeTypeIssue();
    }

    private Date getLastRunDate(String issueName) {
        String settingName = SETTING_PREFIX + Index.SEARCH.indexName() + "-" + issueName;
        Object hasRun = this.pluginSettings.get(settingName);
        if (hasRun == null) {
            this.pluginSettings.put(settingName, (Object)String.valueOf(new Date().getTime()));
            return null;
        }
        try {
            return new Date(Long.parseLong((String)hasRun));
        }
        catch (Exception e) {
            log.warn("Could not determine last run date for '{}'", (Object)issueName, (Object)e);
            return new Date();
        }
    }

    private boolean reindexAffectedRepositories() {
        return (Boolean)Observables.consumeSingle(this.searchClient.getVersion().flatMap(version -> {
            SearchRequestBuilder requestBuilder = ES.search().index(IndexStateMapping.type().indexName()).source(ES.searchSource().source(false).query((QueryBuilder)ES.termQuery((String)IndexStateMapping.RETRIES.fieldName()).value((Value)ES.value((int)(this.indexingSettings.getIndexRetries() + 1)))));
            return this.searchClient.execute(requestBuilder);
        })).fold(err -> {
            if (err.getCause() instanceof ConnectException) {
                log.debug("Could not check for repositories to reindex: {}", (Object)err.getMessage());
            } else {
                log.error("Could not check for repositories to reindex", (Throwable)err);
            }
            return false;
        }, response -> {
            response.getHits().forEach(hit -> {
                log.info("Attempting to reindex repository with ID '{}'", (Object)hit.getId());
                try {
                    ReindexRepositoryFilesEvent reindexEvent = ((ReindexRepositoryFilesEvent.Builder)ReindexRepositoryFilesEvent.builder().repositoryId(Integer.parseInt(hit.getId()))).build();
                    if (!this.processor.queueEvent(reindexEvent)) {
                        log.warn("Failed to queue reindex event for repository with ID '{}'", (Object)hit.getId());
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Could not parse repository ID '{}'", (Object)hit.getId());
                }
            });
            return true;
        });
    }

    private boolean repairUnknownChangeTypeIssue() {
        Date lastRun = this.getLastRunDate("BSERVDEV-14367");
        if (lastRun == null) {
            log.debug("Checking for and repairing known search index issue caused by UNKNOWN change types");
            return this.reindexAffectedRepositories();
        }
        log.debug("Index previously repaired on {}. Skipping.", (Object)lastRun);
        return true;
    }
}

