/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.jobs.checks;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckRegistry;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckResult;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.SearchHealthCheck;
import com.atlassian.bitbucket.internal.search.common.settings.tester.TestBitbucketSearchRequestBuilder;
import com.atlassian.bitbucket.internal.search.indexing.jobs.SearchSynchronizeJob;
import com.atlassian.bitbucket.internal.search.indexing.jobs.StartupChecksJob;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="searchIndexCheck")
public class SearchIndexCheck
implements SearchHealthCheck,
LifecycleAware {
    private static final int WEIGHT = 250;
    private static final Logger log = LoggerFactory.getLogger(SearchIndexCheck.class);
    private final ClusterJobManager clusterJobManager;
    private final SearchClient searchClient;
    private final HealthCheckRegistry healthCheckRegistry;

    @Autowired
    public SearchIndexCheck(ClusterJobManager clusterJobManager, SearchClient searchClient, HealthCheckRegistry healthCheckRegistry) {
        this.searchClient = searchClient;
        this.clusterJobManager = clusterJobManager;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    @Override
    public int getWeight() {
        return 250;
    }

    @Override
    @Nonnull
    public HealthCheckResult manageFailure() {
        log.info("Rescheduling Startup Checks to ensure the bitbucket-search index will be recreated.");
        this.clusterJobManager.unscheduleAdHocJob(StartupChecksJob.class);
        this.clusterJobManager.unscheduleAdHocJob(SearchSynchronizeJob.class);
        this.clusterJobManager.scheduleAdHocJob(Instant.now(), StartupChecksJob.class);
        return HealthCheckResult.RESOLVED;
    }

    public void onStart() {
        this.healthCheckRegistry.registerHealthCheck(this);
    }

    public void onStop() {
        this.healthCheckRegistry.unregisterHealthCheck(this);
    }

    @Override
    public boolean test() {
        return (Boolean)Observables.consumeSingle(this.searchClient.execute(new TestBitbucketSearchRequestBuilder())).fold(err -> false, resp -> !resp.indexExists());
    }
}

