/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.jobs.checks;

import com.atlassian.bitbucket.internal.search.client.VersionCachingSearchClient;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckRegistry;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.HealthCheckResult;
import com.atlassian.bitbucket.internal.search.common.jobs.checks.SearchHealthCheck;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import jakarta.annotation.Nonnull;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component(value="versionCheck")
@DependsOn(value={"indexingConfiguration"})
public class VersionCheck
implements SearchHealthCheck,
LifecycleAware {
    private static final int WEIGHT = 150;
    private final VersionCachingSearchClient client;
    private final HealthCheckRegistry healthCheckRegistry;

    @Autowired
    public VersionCheck(VersionCachingSearchClient client, HealthCheckRegistry healthCheckRegistry) {
        this.client = client;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    @Override
    public int getWeight() {
        return 150;
    }

    @Override
    @Nonnull
    public HealthCheckResult manageFailure() {
        this.client.clearVersionCache();
        return this.test() ? HealthCheckResult.UNRESOLVED : HealthCheckResult.RESOLVED;
    }

    public void onStart() {
        this.healthCheckRegistry.registerHealthCheck(this);
    }

    public void onStop() {
        this.healthCheckRegistry.unregisterHealthCheck(this);
    }

    @Override
    public boolean test() {
        return (Boolean)Observables.consumeSingle(this.client.isVersionCacheStale()).fold(e -> {
            throw new IndexException("Unable to test if client version is stale", (Throwable)e);
        }, Function.identity());
    }
}

