/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.metrics;

import com.atlassian.bitbucket.internal.search.indexing.metrics.BrokenRepositoryCountMXBean;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.BrokenRepositoryService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.annotation.PreDestroy;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrokenRepositoryCountJmxMetrics
implements BrokenRepositoryCountMXBean {
    private static final String MBEAN_NAME = "com.atlassian.bitbucket:type=metrics,category00=search,category01=monitoring,category02=brokenRepos,name=counter";
    private static final Logger log = LoggerFactory.getLogger(BrokenRepositoryCountJmxMetrics.class);
    private final Supplier<Integer> contentCountSupplier;
    private ObjectName registeredMBean;

    @Autowired
    public BrokenRepositoryCountJmxMetrics(BrokenRepositoryService brokenRepositoryService, ApplicationPropertiesService propertiesService) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        if (propertiesService.isJmxEnabled()) {
            this.contentCountSupplier = Suppliers.memoizeWithExpiration(brokenRepositoryService::getBrokenRepositoryCount, (long)30L, (TimeUnit)TimeUnit.SECONDS);
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = new ObjectName(MBEAN_NAME);
            ObjectInstance objectInstance = mBeanServer.registerMBean(this, mBeanName);
            this.registeredMBean = objectInstance.getObjectName();
            log.trace("Registered MBean with name {}", (Object)mBeanName);
        } else {
            this.contentCountSupplier = () -> 0;
        }
    }

    @Override
    public int getContent() {
        return (Integer)this.contentCountSupplier.get();
    }

    @PreDestroy
    public void onStop() throws InstanceNotFoundException, MBeanRegistrationException, MalformedObjectNameException {
        if (this.registeredMBean != null) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = new ObjectName(MBEAN_NAME);
            mBeanServer.unregisterMBean(mBeanName);
        }
    }
}

