/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.queue;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositorySearchIndexingQueuedStatusEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.IndexingQueueManager;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.RepositorySearchIndexingQueueDetailsEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.TrackedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.IndexingQueueMonitoringService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.IndexingQueueTopicService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryCallback;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryRequest;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.SimpleRepositoryIndexingQueueDetails;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="indexingQueueMonitoringService")
public class DefaultIndexingQueueMonitoringService
implements IndexingQueueMonitoringService {
    private final ClusterInformation clusterInformation;
    private final EventPublisher eventPublisher;
    private final IndexingQueueManager indexingQueueManager;
    private final IndexingQueueTopicService indexingQueueTopicService;
    private final PermissionValidationService permissionValidationService;

    @Autowired
    public DefaultIndexingQueueMonitoringService(ClusterService clusterService, EventPublisher eventPublisher, IndexingQueueManager indexingQueueManager, IndexingQueueTopicService indexingQueueTopicService, PermissionValidationService permissionValidationService) {
        this.clusterInformation = clusterService.getInformation();
        this.eventPublisher = eventPublisher;
        this.indexingQueueManager = indexingQueueManager;
        this.indexingQueueTopicService = indexingQueueTopicService;
        this.permissionValidationService = permissionValidationService;
    }

    @Override
    @Nonnull
    public List<RepositoryIndexingQueueDetails> getIndexingQueueDetails(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        String requestId = UUID.randomUUID().toString();
        RepositoryIndexingQueueQueryRequest request = new RepositoryIndexingQueueQueryRequest(requestId, repository.getId());
        RepositoryIndexingQueueQueryCallback callback = new RepositoryIndexingQueueQueryCallback(this.clusterMembership(), false);
        ArrayList<RepositoryIndexingQueueDetails> queueDetailsPerNode = new ArrayList<RepositoryIndexingQueueDetails>();
        Map<String, TrackedEvent> trackedEvents = this.indexingQueueTopicService.publish(request, callback);
        trackedEvents.forEach((nodeId, trackedEvent) -> {
            SimpleRepositoryIndexingQueueDetails.Builder queueDetailsBuilder = new SimpleRepositoryIndexingQueueDetails.Builder((String)nodeId, repository);
            if (trackedEvent != null) {
                queueDetailsBuilder.queued(true).queuedAt(trackedEvent.getQueuedAt());
            }
            queueDetailsPerNode.add(queueDetailsBuilder.build());
        });
        this.eventPublisher.publish((Object)new RepositorySearchIndexingQueueDetailsEvent(this, repository));
        return queueDetailsPerNode;
    }

    @Override
    public RepositoryIndexingQueueDetails getNodeIndexingQueueDetails(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        SimpleRepositoryIndexingQueueDetails.Builder resultBuilder = new SimpleRepositoryIndexingQueueDetails.Builder(this.clusterInformation.getLocalNode().getId(), repository);
        this.indexingQueueManager.getTrackedEvent(EventType.REPOSITORY, repository.getId()).ifPresent(trackedEvent -> resultBuilder.queued(true).queuedAt(trackedEvent.getQueuedAt()));
        return resultBuilder.build();
    }

    @Override
    public boolean isRepositoryQueued(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        String requestId = UUID.randomUUID().toString();
        RepositoryIndexingQueueQueryRequest request = new RepositoryIndexingQueueQueryRequest(requestId, repository.getId());
        RepositoryIndexingQueueQueryCallback callback = new RepositoryIndexingQueueQueryCallback(this.clusterMembership(), true);
        Map<String, TrackedEvent> trackedEvents = this.indexingQueueTopicService.publish(request, callback);
        this.eventPublisher.publish((Object)new RepositorySearchIndexingQueuedStatusEvent(this, repository));
        return trackedEvents.entrySet().stream().anyMatch(entry -> entry.getValue() != null);
    }

    @Nonnull
    private Set<String> clusterMembership() {
        return this.clusterInformation.getNodes().stream().filter(ClusterNode::isFullyStarted).map(ClusterNode::getVmId).collect(Collectors.toSet());
    }
}

