/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.queue;

import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.IndexingQueueManager;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.TrackedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.IndexingQueueTopicService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryCallback;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryRequest;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryResponse;
import com.atlassian.bitbucket.topic.MessageEvent;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultIndexingQueueTopicService
implements IndexingQueueTopicService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexingQueueTopicService.class);
    private static final String REQUEST_TIMEOUT_CONFIG = "${plugin.search.indexing.cluster-queue-status.timeout:5}";
    private final ClusterInformation clusterInformation;
    private final IndexingQueueManager indexingQueueManager;
    private final String localNodeId;
    private final ConcurrentMap<String, RepositoryIndexingQueueQueryCallback> pendingRequests;
    private final int requestTimeout;
    private final Topic<RepositoryIndexingQueueQueryRequest> requestTopic;
    private final Topic<RepositoryIndexingQueueQueryResponse> responseTopic;
    private String requestTopicId;
    private String responseTopicId;

    @Autowired
    public DefaultIndexingQueueTopicService(ClusterService clusterService, IndexingQueueManager indexingQueueManager, TopicService topicService, @Value(value="${plugin.search.indexing.cluster-queue-status.timeout:5}") int requestTimeout) {
        this.indexingQueueManager = indexingQueueManager;
        this.requestTimeout = requestTimeout;
        this.clusterInformation = clusterService.getInformation();
        this.localNodeId = this.clusterInformation.getLocalNode().getVmId();
        this.pendingRequests = new ConcurrentHashMap<String, RepositoryIndexingQueueQueryCallback>();
        this.requestTopic = topicService.getTopic("repository-indexing-queue-query-request", TopicSettings.builder(RepositoryIndexingQueueQueryRequest.class).build());
        this.responseTopic = topicService.getTopic("repository-indexing-queue-query-response", TopicSettings.builder(RepositoryIndexingQueueQueryResponse.class).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, TrackedEvent> publish(@Nonnull RepositoryIndexingQueueQueryRequest request, @Nonnull RepositoryIndexingQueueQueryCallback callback) {
        Objects.requireNonNull(request, "request");
        this.pendingRequests.put(request.requestId(), callback);
        try {
            this.requestTopic.publish((Serializable)request);
            if (callback.await(this.requestTimeout, TimeUnit.SECONDS)) {
                Map<String, TrackedEvent> map = callback.getResponses();
                return map;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.debug("Interrupted while waiting for all nodes to respond");
        }
        finally {
            this.pendingRequests.remove(request.requestId());
        }
        throw new IllegalStateException("Timed out waiting for all nodes to respond");
    }

    @PostConstruct
    public void subscribeTopics() {
        this.requestTopicId = this.requestTopic.subscribe(this::handleRequest);
        log.debug("Subscribed to request topic: {} with subscription id: {}", (Object)"repository-indexing-queue-query-request", (Object)this.requestTopicId);
        this.responseTopicId = this.responseTopic.subscribe(this::handleResponse);
        log.debug("Subscribed to response topic: {} with subscription id: {}", (Object)"repository-indexing-queue-query-response", (Object)this.responseTopicId);
    }

    @PreDestroy
    public void unSubscribeTopics() {
        if (this.requestTopic != null && !this.requestTopic.unsubscribe(this.requestTopicId)) {
            log.warn("Could not unsubscribe from request topic with subscription id: {}", (Object)this.requestTopicId);
        }
        if (this.responseTopic != null && !this.responseTopic.unsubscribe(this.responseTopicId)) {
            log.warn("Could not unsubscribe from response topic with subscription id: {}", (Object)this.responseTopicId);
        }
    }

    private void handleRequest(MessageEvent<RepositoryIndexingQueueQueryRequest> event) {
        RepositoryIndexingQueueQueryRequest request = (RepositoryIndexingQueueQueryRequest)event.getMessage();
        this.indexingQueueManager.getTrackedEvent(EventType.REPOSITORY, request.repositoryId()).ifPresentOrElse(trackedEvent -> this.responseTopic.publish((Serializable)new RepositoryIndexingQueueQueryResponse(request.requestId(), this.localNodeId, (TrackedEvent)trackedEvent)), () -> this.responseTopic.publish((Serializable)new RepositoryIndexingQueueQueryResponse(request.requestId(), this.localNodeId, null)));
    }

    private void handleResponse(MessageEvent<RepositoryIndexingQueueQueryResponse> event) {
        RepositoryIndexingQueueQueryResponse response = (RepositoryIndexingQueueQueryResponse)event.getMessage();
        RepositoryIndexingQueueQueryCallback callback = (RepositoryIndexingQueueQueryCallback)this.pendingRequests.get(response.requestId());
        if (callback != null) {
            callback.onResponse(response);
        }
    }
}

