/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.queue;

import com.atlassian.bitbucket.internal.search.indexing.event.queue.TrackedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueQueryResponse;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RepositoryIndexingQueueQueryCallback {
    private final Set<String> actualRespondingNodeIds;
    private final Set<String> expectedRespondingNodeIds;
    private final CountDownLatch latch;
    private final Map<String, TrackedEvent> responses;
    private final boolean returnOnFirstResponse;

    public RepositoryIndexingQueueQueryCallback(Set<String> expectedRespondingNodeIds, boolean returnOnFirstResponse) {
        this.expectedRespondingNodeIds = expectedRespondingNodeIds;
        this.returnOnFirstResponse = returnOnFirstResponse;
        this.latch = new CountDownLatch(1);
        this.actualRespondingNodeIds = new HashSet<String>();
        this.responses = new HashMap<String, TrackedEvent>();
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.latch.await(timeout, timeUnit);
    }

    public Map<String, TrackedEvent> getResponses() {
        return this.responses;
    }

    public void onResponse(@Nonnull RepositoryIndexingQueueQueryResponse response) {
        Objects.requireNonNull(response, "response");
        this.responses.put(response.responderId(), response.trackedEvent());
        this.actualRespondingNodeIds.add(response.responderId());
        if (this.returnOnFirstResponse && response.trackedEvent() != null || Objects.equals(this.actualRespondingNodeIds, this.expectedRespondingNodeIds)) {
            this.latch.countDown();
        }
    }
}

