/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.queue;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueDetails;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class SimpleRepositoryIndexingQueueDetails
implements RepositoryIndexingQueueDetails {
    private final Instant capturedAt;
    private final String nodeId;
    private final boolean queued;
    private final Instant queuedAt;
    private final Repository repository;

    private SimpleRepositoryIndexingQueueDetails(Builder builder) {
        this.capturedAt = builder.capturedAt;
        this.nodeId = builder.nodeId;
        this.queued = builder.queued;
        this.queuedAt = builder.queuedAt;
        this.repository = builder.repository;
    }

    @Override
    @Nonnull
    public Instant getCapturedAt() {
        return this.capturedAt;
    }

    @Override
    @Nonnull
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    @Nonnull
    public Optional<Instant> getQueuedAt() {
        return Optional.ofNullable(this.queuedAt);
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    public static class Builder {
        private final Instant capturedAt;
        private final String nodeId;
        private final Repository repository;
        private boolean queued;
        private Instant queuedAt;

        public Builder(@Nonnull String nodeId, @Nonnull Repository repository) {
            this(Instant.now(), nodeId, repository);
        }

        public Builder(@Nonnull Instant capturedAt, @Nonnull String nodeId, @Nonnull Repository repository) {
            this.capturedAt = Objects.requireNonNull(capturedAt, "capturedAt");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        @Nonnull
        public SimpleRepositoryIndexingQueueDetails build() {
            return new SimpleRepositoryIndexingQueueDetails(this);
        }

        @Nonnull
        public Builder queued(boolean queued) {
            this.queued = queued;
            return this;
        }

        @Nonnull
        public Builder queuedAt(@Nullable Instant queuedAt) {
            this.queuedAt = queuedAt;
            return this;
        }
    }
}

