/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.indexing.administration.DefaultIndexConfigurationService;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositorySearchIndexingBrokenStatusEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositorySearchIndexingReindexBrokenRepositoriesEvent;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexingSettings;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.BrokenRepositoryService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingQueueException;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingStatus;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.SimpleRepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.util.ElderScroll;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.content.ObjectContent;
import com.atlassian.elasticsearch.client.query.QueryBuilder;
import com.atlassian.elasticsearch.client.query.RangeQueryBuilder;
import com.atlassian.elasticsearch.client.query.Value;
import com.atlassian.elasticsearch.client.search.Hit;
import com.atlassian.elasticsearch.client.search.IndexCountRequestBuilder;
import com.atlassian.elasticsearch.client.search.IndexCountSourceBuilder;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="brokenRepositoryService")
public class DefaultBrokenRepositoryService
implements BrokenRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultBrokenRepositoryService.class);
    private static final Duration SCROLL_ID_DURATION = Duration.ofMinutes(1L);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final IndexingSettings indexingSettings;
    private final IndexEventQueueProcessor processor;
    private final RepositoryService repositoryService;
    private final SearchClient searchClient;

    @Autowired
    public DefaultBrokenRepositoryService(EventPublisher eventPublisher, I18nService i18nService, SearchClient searchClient, IndexEventQueueProcessor processor, IndexingSettings indexingSettings, RepositoryService repositoryService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.indexingSettings = indexingSettings;
        this.processor = processor;
        this.repositoryService = repositoryService;
        this.searchClient = searchClient;
    }

    @Override
    public int getBrokenRepositoryCount() {
        RangeQueryBuilder rangeQuery = ES.rangeQuery((String)IndexStateMapping.RETRIES.fieldName()).gt((Value)ES.value((int)this.indexingSettings.getIndexRetries()));
        IndexCountRequestBuilder builder = ES.searchCount().index(IndexStateMapping.type().indexName()).source(new IndexCountSourceBuilder().query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)rangeQuery)));
        AtomicInteger brokenRepositoryCount = new AtomicInteger(0);
        this.searchClient.execute(builder).toBlocking().subscribe(counter -> brokenRepositoryCount.set(((Number)counter.getContent().getNumber("count").orElse(0)).intValue()));
        return brokenRepositoryCount.get();
    }

    @Override
    @Nonnull
    public Page<RepositoryIndexingDetails> getBrokenRepositoryIndexingDetails(@Nonnull PageRequest pageRequest) {
        PageRequest boundedPageRequest = Objects.requireNonNull(pageRequest, "pageRequest").buildRestrictedPageRequest(DefaultIndexConfigurationService.MAX_RESULT_WINDOW);
        RangeQueryBuilder rangeQuery = ES.rangeQuery((String)IndexStateMapping.RETRIES.fieldName()).gt((Value)ES.value((int)this.indexingSettings.getIndexRetries()));
        SearchSourceBuilder searchSourceBuilder = this.buildSearchSourceRequest(boundedPageRequest, rangeQuery);
        ImmutableList results = ((ImmutableList.Builder)new ElderScroll(this.searchClient).search(searchSourceBuilder, IndexStateMapping.type(), SCROLL_ID_DURATION).map(this::resolveSearchHit).filter(Objects::nonNull).collect(ImmutableList.Builder::new, ImmutableList.Builder::add).toBlocking().single()).build();
        this.eventPublisher.publish((Object)new RepositorySearchIndexingBrokenStatusEvent(this));
        return PageUtils.createPage((Iterable)results, (PageRequest)boundedPageRequest);
    }

    @Override
    public void reindexRepositories(@Nonnull Collection<Repository> repositories) {
        Objects.requireNonNull(repositories, "repositories");
        HashSet invalidRepositories = new HashSet();
        repositories.forEach(repo -> {
            ReindexRepositoryFilesEvent reindexEvent = ((ReindexRepositoryFilesEvent.Builder)ReindexRepositoryFilesEvent.builder().repositoryId(repo.getId())).build();
            if (!this.processor.queueEvent(reindexEvent)) {
                invalidRepositories.add(String.format("%s/%s", repo.getProject().getKey(), repo.getSlug()));
            }
        });
        if (!invalidRepositories.isEmpty()) {
            throw new RepositoryIndexingQueueException(this.i18nService.createKeyedMessage("bitbucket.search.reindexing.queue.error", new Object[]{invalidRepositories}));
        }
        this.eventPublisher.publish((Object)new RepositorySearchIndexingReindexBrokenRepositoriesEvent(this, repositories.size()));
    }

    private SearchSourceBuilder buildSearchSourceRequest(PageRequest pageRequest, RangeQueryBuilder rangeQuery) {
        return ES.searchSource().query((QueryBuilder)ES.boolQuery().filter((QueryBuilder)rangeQuery)).sort("_doc").source(IndexStateMapping.INDEXED_TIMESTAMP.fieldName(), new String[]{IndexStateMapping.INDEXED_COMMIT_ID.fieldName(), IndexStateMapping.INDEXING_ERROR.fieldName()}).page(ES.page().from(pageRequest.getStart()).size(pageRequest.getLimit()).build());
    }

    private RepositoryIndexingDetails resolveSearchHit(Hit searchHit) {
        ObjectContent source = (ObjectContent)searchHit.getSource().orElseThrow(() -> new IllegalStateException("Repository hit does not have a source"));
        int repositoryId = Integer.parseInt(searchHit.getId());
        Repository repository = this.repositoryService.getById(repositoryId);
        if (repository == null) {
            log.debug("Broken index state found for non-existent repository ID {}, ignoring", (Object)repositoryId);
            return null;
        }
        SimpleRepositoryIndexingDetails.Builder builder = new SimpleRepositoryIndexingDetails.Builder(repository, RepositoryIndexingStatus.BROKEN);
        String lastIndexedCommitId = source.getStringOrThrow(IndexStateMapping.INDEXED_COMMIT_ID.fieldName());
        Optional indexingError = source.getString(IndexStateMapping.INDEXING_ERROR.fieldName());
        Optional indexedTimestamp = source.getNumber(IndexStateMapping.INDEXED_TIMESTAMP.fieldName());
        builder.lastIndexedCommitId(lastIndexedCommitId);
        indexingError.ifPresent(builder::indexingError);
        indexedTimestamp.ifPresent(instant -> builder.lastIndexedTimestamp(Instant.ofEpochMilli(instant.longValue())));
        return builder.build();
    }
}

