/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.repository;

import com.atlassian.bitbucket.internal.search.indexing.event.RepositorySearchIndexingDetailsEvent;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexState;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexStateService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetailsService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingStatus;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingStatusResolver;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.SimpleRepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import org.springframework.stereotype.Service;

@Service(value="repositoryIndexingDetailsService")
public class DefaultRepositoryIndexingDetailsService
implements RepositoryIndexingDetailsService {
    private final EventPublisher eventPublisher;
    private final IndexStateService indexStateService;
    private final PermissionValidationService permissionValidationService;
    private final RepositoryIndexingStatusResolver repositoryIndexingStatusResolver;

    public DefaultRepositoryIndexingDetailsService(EventPublisher eventPublisher, IndexStateService indexStateService, PermissionValidationService permissionValidationService, RepositoryIndexingStatusResolver repositoryIndexingStatusResolver) {
        this.eventPublisher = eventPublisher;
        this.indexStateService = indexStateService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryIndexingStatusResolver = repositoryIndexingStatusResolver;
    }

    @Override
    @Nonnull
    public RepositoryIndexingDetails getIndexingDetails(Repository repository) {
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_ADMIN);
        int repositoryId = repository.getId();
        this.eventPublisher.publish((Object)new RepositorySearchIndexingDetailsEvent(this, repository));
        return Observables.consumeSingle(this.indexStateService.load(repositoryId)).toOptional().map(state -> this.resolveIndexingDetails((IndexState)state, repository)).orElse(new SimpleRepositoryIndexingDetails.Builder(repository, RepositoryIndexingStatus.UNKNOWN).build());
    }

    private RepositoryIndexingDetails resolveIndexingDetails(IndexState state, Repository repository) {
        RepositoryIndexingStatus status = this.repositoryIndexingStatusResolver.getIndexingStatus(state, repository);
        SimpleRepositoryIndexingDetails.Builder builder = new SimpleRepositoryIndexingDetails.Builder(repository, status);
        return builder.lastIndexedCommitId(state.getIndexedCommitId().orElse(null)).lastIndexedTimestamp(state.getIndexedTimestamp().orElse(null)).indexingError(state.getIndexingError().orElse(null)).build();
    }
}

