/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.repository;

import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexService;
import com.atlassian.bitbucket.internal.search.indexing.indexer.IndexState;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.IndexingQueueMonitoringService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingStatus;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import org.springframework.stereotype.Component;

@Component
class RepositoryIndexingStatusResolver {
    private final IndexingQueueMonitoringService indexingQueueMonitoringService;
    private final IndexService indexService;
    private final RefService refService;

    RepositoryIndexingStatusResolver(IndexingQueueMonitoringService indexingQueueMonitoringService, IndexService indexService, RefService refService) {
        this.indexingQueueMonitoringService = indexingQueueMonitoringService;
        this.indexService = indexService;
        this.refService = refService;
    }

    public RepositoryIndexingStatus getIndexingStatus(IndexState indexState, Repository repository) {
        if (this.indexService.exceedsMaximumRetries(indexState)) {
            return RepositoryIndexingStatus.BROKEN;
        }
        if (this.isIndexed(indexState, repository)) {
            return RepositoryIndexingStatus.INDEXED;
        }
        if (this.isQueued(repository)) {
            return RepositoryIndexingStatus.QUEUED;
        }
        return RepositoryIndexingStatus.NOT_INDEXED;
    }

    private boolean isIndexed(IndexState indexState, Repository repository) {
        if (indexState.getIndexedCommitId().isPresent()) {
            try {
                String latestCommitId = this.refService.getDefaultBranch(repository).getLatestCommit();
                String lastIndexedCommitId = indexState.getIndexedCommitId().get();
                return lastIndexedCommitId.equals(latestCommitId);
            }
            catch (NoDefaultBranchException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isQueued(Repository repository) {
        return this.indexingQueueMonitoringService.isRepositoryQueued(repository);
    }
}

