/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.repository;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingStatus;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;

public class SimpleRepositoryIndexingDetails
implements RepositoryIndexingDetails {
    private final String indexingError;
    private final String lastIndexedCommitId;
    private final Instant lastIndexedTimestamp;
    private final String projectKey;
    private final String repositorySlug;
    private final RepositoryIndexingStatus status;

    private SimpleRepositoryIndexingDetails(Builder builder) {
        this.indexingError = builder.indexingError;
        this.lastIndexedCommitId = builder.lastIndexedCommitId;
        this.lastIndexedTimestamp = builder.lastIndexedTimestamp;
        this.projectKey = builder.projectKey;
        this.repositorySlug = builder.repositorySlug;
        this.status = builder.status;
    }

    @Override
    @Nullable
    public String getIndexingError() {
        return this.indexingError;
    }

    @Override
    @Nullable
    public String getLastIndexedCommitId() {
        return this.lastIndexedCommitId;
    }

    @Override
    @Nullable
    public Instant getLastIndexedTimestamp() {
        return this.lastIndexedTimestamp;
    }

    @Override
    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    @Nonnull
    public String getRepositorySlug() {
        return this.repositorySlug;
    }

    @Override
    @Nonnull
    public RepositoryIndexingStatus getStatus() {
        return this.status;
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexingError", (Object)this.indexingError).add("lastIndexedCommitId", (Object)this.lastIndexedCommitId).add("lastIndexedTimestamp", (Object)this.lastIndexedTimestamp).add("projectKey", (Object)this.projectKey).add("repositorySlug", (Object)this.repositorySlug).add("status", (Object)this.status).toString();
    }

    public static class Builder {
        private final String projectKey;
        private final String repositorySlug;
        private final RepositoryIndexingStatus status;
        private String indexingError;
        private String lastIndexedCommitId;
        private Instant lastIndexedTimestamp;

        public Builder(@Nonnull RepositoryIndexingDetails repositoryIndexingDetails) {
            Objects.requireNonNull(repositoryIndexingDetails, "repositoryIndexingDetails");
            this.indexingError = repositoryIndexingDetails.getIndexingError();
            this.lastIndexedCommitId = repositoryIndexingDetails.getLastIndexedCommitId();
            this.lastIndexedTimestamp = repositoryIndexingDetails.getLastIndexedTimestamp();
            this.projectKey = repositoryIndexingDetails.getProjectKey();
            this.repositorySlug = repositoryIndexingDetails.getRepositorySlug();
            this.status = repositoryIndexingDetails.getStatus();
        }

        public Builder(@Nonnull Repository repository, @Nonnull RepositoryIndexingStatus status) {
            Objects.requireNonNull(repository, "repository");
            this.projectKey = repository.getProject().getKey();
            this.repositorySlug = repository.getSlug();
            this.status = Objects.requireNonNull(status, "status");
        }

        @Nonnull
        public RepositoryIndexingDetails build() {
            Objects.requireNonNull(this.status, "SimpleRepositoryIndexingDetails must have a status");
            return new SimpleRepositoryIndexingDetails(this);
        }

        @Nonnull
        public Builder indexingError(@Nullable String indexingError) {
            this.indexingError = indexingError;
            return this;
        }

        @Nonnull
        public Builder lastIndexedCommitId(@Nullable String lastIndexedCommitId) {
            this.lastIndexedCommitId = lastIndexedCommitId;
            return this;
        }

        @Nonnull
        public Builder lastIndexedTimestamp(@Nullable Instant lastIndexedTimestamp) {
            this.lastIndexedTimestamp = lastIndexedTimestamp;
            return this;
        }
    }
}

