/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.IndexingProperties;
import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.AbstractIndexingThreadStateResolver;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadState;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="brokenThreadStateResolver")
public class BrokenThreadStateResolver
extends AbstractIndexingThreadStateResolver {
    static final int ORDER = -2147483647;
    private final Supplier<Instant> nowSupplier;
    private final Duration unresponsiveTimeout;

    @Autowired
    public BrokenThreadStateResolver(IndexingProperties indexingProperties) {
        this(Instant::now, indexingProperties.getIndexingMonitoringUnresponsiveTimeout());
    }

    BrokenThreadStateResolver(Supplier<Instant> nowSupplier, Duration unresponsiveTimeout) {
        this.nowSupplier = nowSupplier;
        this.unresponsiveTimeout = unresponsiveTimeout;
    }

    public int getOrder() {
        return -2147483647;
    }

    @Override
    protected Collection<AbstractIndexingThreadStateResolver.Condition> getConditions() {
        return List.of(this.getIdleButUnresponsiveCondition(), this.getProcessingButUnresponsiveCondition());
    }

    @Override
    protected IndexingThreadState.Code getStateCode() {
        return IndexingThreadState.Code.BROKEN;
    }

    private AbstractIndexingThreadStateResolver.Condition getIdleButUnresponsiveCondition() {
        MutableObject message = new MutableObject((Object)"");
        return new AbstractIndexingThreadStateResolver.Condition(context -> {
            Optional<QueuedEvent> currentEvent = context.getCurrentEvent();
            Instant lastActivityTimestamp = context.getLastActivityTimestamp().orElse(null);
            if (currentEvent.isEmpty() && this.isUnresponsive(lastActivityTimestamp) && BrokenThreadStateResolver.isQueueNotEmpty(context.getQueueSize())) {
                message.setValue((Object)"The indexing thread is currently idle, has been unresponsive since %s,\nand the queue is not empty. This indicates that something is blocking the\nthread from polling items form the queue.\n".formatted(lastActivityTimestamp));
                return true;
            }
            return false;
        }, () -> ((MutableObject)message).getValue());
    }

    private AbstractIndexingThreadStateResolver.Condition getProcessingButUnresponsiveCondition() {
        MutableObject message = new MutableObject((Object)"");
        return new AbstractIndexingThreadStateResolver.Condition(context -> {
            Optional<QueuedEvent> currentEvent = context.getCurrentEvent();
            Instant lastActivityTimestamp = context.getLastActivityTimestamp().orElse(null);
            if (currentEvent.isPresent() && this.isUnresponsive(lastActivityTimestamp)) {
                message.setValue((Object)"The indexing thread is currently processing %s, but has been unresponsive since %s.\nThis indicates that the the thread may be blocked processing the current event.\n".formatted(currentEvent.get(), lastActivityTimestamp));
                return true;
            }
            return false;
        }, () -> ((MutableObject)message).getValue());
    }

    private static boolean isQueueNotEmpty(int queueSize) {
        return queueSize >= 0;
    }

    private boolean isUnresponsive(Instant lastActivityTimestamp) {
        if (lastActivityTimestamp == null) {
            return false;
        }
        Instant unresponsiveDeadline = lastActivityTimestamp.plus(this.unresponsiveTimeout);
        return unresponsiveDeadline.isBefore(this.nowSupplier.get());
    }
}

