/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.event.DelayedScheduler;
import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositorySearchIndexingThreadSnapshotEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.queue.IndexingQueueManager;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingProcess;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadContext;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadLifecycleListener;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadMonitoringService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadState;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadStateResolver;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadStatus;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadStatusCollector;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.SimpleIndexingProcess;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.SimpleIndexingThreadContext;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.SimpleIndexingThreadDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.SimpleIndexingThreadState;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="indexingThreadMonitoringService")
public class DefaultIndexingThreadMonitoringService
implements IndexingThreadMonitoringService,
IndexingThreadLifecycleListener {
    private final DelayedScheduler<QueuedEvent> delayedScheduler;
    private final EventPublisher eventPublisher;
    private final IndexingQueueManager indexingQueueManager;
    private final Supplier<Instant> nowSupplier;
    private final PermissionValidationService permissionValidationService;
    private final List<IndexingThreadStateResolver> threadStateResolvers;
    private final IndexingThreadStatusCollector threadStatusCollector;

    @Autowired
    public DefaultIndexingThreadMonitoringService(EventPublisher eventPublisher, PermissionValidationService permissionValidationService, IndexingQueueManager indexingQueueManager, DelayedScheduler<QueuedEvent> delayedScheduler, List<IndexingThreadStateResolver> threadStateResolvers, IndexingThreadStatusCollector threadStatusCollector) {
        this(eventPublisher, permissionValidationService, indexingQueueManager, Instant::now, delayedScheduler, threadStateResolvers, threadStatusCollector);
    }

    @VisibleForTesting
    DefaultIndexingThreadMonitoringService(EventPublisher eventPublisher, PermissionValidationService permissionValidationService, IndexingQueueManager indexingQueueManager, Supplier<Instant> nowSupplier, DelayedScheduler<QueuedEvent> delayedScheduler, List<IndexingThreadStateResolver> threadStateResolvers, IndexingThreadStatusCollector threadStatusCollector) {
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.indexingQueueManager = indexingQueueManager;
        this.nowSupplier = nowSupplier;
        this.delayedScheduler = delayedScheduler;
        this.threadStateResolvers = threadStateResolvers;
        this.threadStatusCollector = threadStatusCollector;
    }

    @Override
    @Nonnull
    public List<IndexingThreadDetails> getThreadDetails() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.eventPublisher.publish((Object)new RepositorySearchIndexingThreadSnapshotEvent(this));
        return this.threadStatusCollector.getAllThreadStatuses().entrySet().stream().map(entry -> this.createThreadDetails((String)entry.getKey(), (IndexingThreadStatus)entry.getValue())).toList();
    }

    @Override
    public void onIndexingThreadStarted(@Nonnull Future<Boolean> indexingWorker) {
        Objects.requireNonNull(indexingWorker, "indexingWorker");
        this.threadStatusCollector.updateFuture(Thread.currentThread().getName(), indexingWorker);
    }

    @Override
    public void onProcessingFinished() {
        this.threadStatusCollector.deleteEventAndTask(Thread.currentThread().getName());
    }

    @Override
    public void onProcessingStarted(@Nonnull QueuedEvent currentEvent) {
        Objects.requireNonNull(currentEvent, "currentEvent");
        this.threadStatusCollector.updateCurrentEvent(Thread.currentThread().getName(), currentEvent);
    }

    @Override
    public void onProcessingUpdate(@Nonnull String currentTask, @Nonnull String threadName) {
        Objects.requireNonNull(currentTask, "currentTask");
        Objects.requireNonNull(threadName, "threadName");
        this.threadStatusCollector.updateCurrentTask(threadName, currentTask);
    }

    @Override
    public void onProcessingUpdate(@Nonnull String currentTask) {
        Objects.requireNonNull(currentTask, "currentTask");
        this.threadStatusCollector.updateCurrentTask(Thread.currentThread().getName(), currentTask);
    }

    private IndexingThreadContext createThreadContext(IndexingThreadStatus threadStatus) {
        return new SimpleIndexingThreadContext.Builder().indexingWorkerActive(DefaultIndexingThreadMonitoringService.isIndexingWorkerActive(threadStatus.getFuture())).currentEvent(threadStatus.getCurrentEvent()).currentTaskDescription(threadStatus.getCurrentTask()).lastActivityTimestamp(threadStatus.getLastActivityTimestamp()).queueSize(this.indexingQueueManager.size()).delayedQueueSize(this.delayedScheduler.getNumberOfScheduledItems()).build();
    }

    private IndexingThreadDetails createThreadDetails(String threadName, IndexingThreadStatus threadStatus) {
        IndexingThreadContext context = this.createThreadContext(threadStatus);
        return new SimpleIndexingThreadDetails.Builder(this.nowSupplier.get(), this.getThreadState(context), threadName).currentProcess(DefaultIndexingThreadMonitoringService.getCurrentProcess(context)).queueSize(context.getQueueSize()).delayedQueueSize(context.getDelayedQueueSize()).build();
    }

    private static IndexingProcess getCurrentProcess(IndexingThreadContext context) {
        Optional<QueuedEvent> currentEvent = context.getCurrentEvent();
        Optional<String> currentTaskDescription = context.getCurrentTaskDescription();
        if (currentEvent.isPresent() && currentTaskDescription.isPresent()) {
            return new SimpleIndexingProcess(currentEvent.get(), currentTaskDescription.get());
        }
        return null;
    }

    private IndexingThreadState getThreadState(IndexingThreadContext context) {
        return this.threadStateResolvers.stream().map(stateResolver -> stateResolver.resolveState(context)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(new SimpleIndexingThreadState(IndexingThreadState.Code.UNKNOWN, "Cannot resolve state for thread %s".formatted(context)));
    }

    private static boolean isIndexingWorkerActive(Future<Boolean> indexingWorker) {
        return indexingWorker != null && !indexingWorker.isDone() && !indexingWorker.isCancelled();
    }
}

