/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadStatus;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadStatusCollector;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component(value="indexingThreadStatusCollector")
public class DefaultIndexingThreadStatusCollector
implements IndexingThreadStatusCollector {
    private final Supplier<Instant> nowSupplier;
    private final Map<String, IndexingThreadStatus> threadStatusMap;

    public DefaultIndexingThreadStatusCollector() {
        this(Instant::now);
    }

    @VisibleForTesting
    DefaultIndexingThreadStatusCollector(@Nonnull Supplier<Instant> nowSupplier) {
        Objects.requireNonNull(nowSupplier, "nowSupplier");
        this.nowSupplier = nowSupplier;
        this.threadStatusMap = new ConcurrentSkipListMap<String, IndexingThreadStatus>();
    }

    @Override
    public void deleteEventAndTask(@Nonnull String threadName) {
        Objects.requireNonNull(threadName, "threadName");
        this.threadStatusMap.computeIfPresent(threadName, (key, value) -> {
            value.setCurrentEvent(null);
            value.setCurrentTask(null);
            return value;
        });
    }

    @Override
    @Nonnull
    public Map<String, IndexingThreadStatus> getAllThreadStatuses() {
        return Collections.unmodifiableMap(this.threadStatusMap);
    }

    @Override
    public void updateCurrentEvent(@Nonnull String threadName, @Nonnull QueuedEvent currentEvent) {
        Objects.requireNonNull(threadName, "threadName");
        Objects.requireNonNull(currentEvent, "currentEvent");
        if (threadName.startsWith("search-indexing")) {
            this.threadStatusMap.compute(threadName, (key, value) -> {
                if (value == null) {
                    return new IndexingThreadStatus(currentEvent, this.nowSupplier.get(), null, null);
                }
                value.setLastActivityTimestamp(this.nowSupplier.get());
                value.setCurrentEvent(currentEvent);
                return value;
            });
        }
    }

    @Override
    public void updateCurrentTask(@Nonnull String threadName, @Nonnull String currentTask) {
        Objects.requireNonNull(threadName, "threadName");
        Objects.requireNonNull(currentTask, "currentTask");
        if (threadName.startsWith("search-indexing")) {
            this.threadStatusMap.compute(threadName, (key, value) -> {
                if (value == null) {
                    return new IndexingThreadStatus(null, this.nowSupplier.get(), currentTask, null);
                }
                value.setLastActivityTimestamp(this.nowSupplier.get());
                value.setCurrentTask(currentTask);
                return value;
            });
        }
    }

    @Override
    public void updateFuture(@Nonnull String threadName, @Nonnull Future<Boolean> future) {
        Objects.requireNonNull(threadName, "threadName");
        Objects.requireNonNull(future, "future");
        if (threadName.startsWith("search-indexing")) {
            this.threadStatusMap.compute(threadName, (key, value) -> {
                if (value == null) {
                    return new IndexingThreadStatus(null, this.nowSupplier.get(), null, future);
                }
                value.setLastActivityTimestamp(this.nowSupplier.get());
                value.setFuture(future);
                return value;
            });
        }
    }
}

