/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public class IndexingThreadStatus {
    private final AtomicReference<QueuedEvent> currentEvent = new AtomicReference();
    private final AtomicReference<String> currentTask = new AtomicReference();
    private final AtomicReference<Future<Boolean>> future = new AtomicReference();
    private final AtomicReference<Instant> lastActivityTimestamp = new AtomicReference();

    IndexingThreadStatus(@Nullable QueuedEvent currentEvent, @Nonnull Instant lastActivityTimestamp, @Nullable String currentTask, @Nullable Future<Boolean> future) {
        this.currentEvent.set(currentEvent);
        this.currentTask.set(currentTask);
        this.future.set(future);
        this.lastActivityTimestamp.set(lastActivityTimestamp);
    }

    @Nullable
    public QueuedEvent getCurrentEvent() {
        return this.currentEvent.get();
    }

    @Nullable
    public String getCurrentTask() {
        return this.currentTask.get();
    }

    @Nullable
    public Future<Boolean> getFuture() {
        return this.future.get();
    }

    @Nonnull
    public Instant getLastActivityTimestamp() {
        return this.lastActivityTimestamp.get();
    }

    public void setCurrentEvent(@Nullable QueuedEvent currentEvent) {
        this.currentEvent.set(currentEvent);
    }

    public void setCurrentTask(@Nullable String currentTask) {
        this.currentTask.set(currentTask);
    }

    public void setFuture(@Nonnull Future<Boolean> future) {
        this.future.set(future);
    }

    public void setLastActivityTimestamp(@Nonnull Instant lastActivityTimestamp) {
        Objects.requireNonNull(lastActivityTimestamp, "lastActivityTimestamp");
        this.lastActivityTimestamp.set(lastActivityTimestamp);
    }
}

