/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.AbstractIndexingThreadStateResolver;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadState;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.mutable.MutableObject;
import org.springframework.stereotype.Component;

@Component(value="processingThreadStateResolver")
public class ProcessingThreadStateResolver
extends AbstractIndexingThreadStateResolver {
    static final int ORDER = -2147483646;

    public int getOrder() {
        return -2147483646;
    }

    @Override
    protected Collection<AbstractIndexingThreadStateResolver.Condition> getConditions() {
        MutableObject message = new MutableObject((Object)"");
        return List.of(new AbstractIndexingThreadStateResolver.Condition(context -> {
            Optional<QueuedEvent> queuedEvent = context.getCurrentEvent();
            if (context.isIndexingWorkerActive() && queuedEvent.isPresent()) {
                message.setValue((Object)"The indexing thread is currently processing %s".formatted(queuedEvent.get()));
                return true;
            }
            return false;
        }, () -> ((MutableObject)message).getValue()));
    }

    @Override
    protected IndexingThreadState.Code getStateCode() {
        return IndexingThreadState.Code.PROCESSING;
    }
}

