/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Optional;

public class SimpleIndexingThreadContext
implements IndexingThreadContext {
    private final QueuedEvent currentEvent;
    private final String currentTaskDescription;
    private final int delayedQueueSize;
    private final boolean indexingWorkerActive;
    private final Instant lastActivityTimestamp;
    private final int queueSize;

    private SimpleIndexingThreadContext(Builder builder) {
        this.currentEvent = builder.currentEvent;
        this.currentTaskDescription = builder.currentTaskDescription;
        this.delayedQueueSize = builder.delayedQueueSize;
        this.indexingWorkerActive = builder.indexingWorkerActive;
        this.lastActivityTimestamp = builder.lastActivityTimestamp;
        this.queueSize = builder.queueSize;
    }

    @Override
    @Nonnull
    public Optional<QueuedEvent> getCurrentEvent() {
        return Optional.ofNullable(this.currentEvent);
    }

    @Override
    @Nonnull
    public Optional<String> getCurrentTaskDescription() {
        return Optional.ofNullable(this.currentTaskDescription);
    }

    @Override
    public int getDelayedQueueSize() {
        return this.delayedQueueSize;
    }

    @Override
    @Nonnull
    public Optional<Instant> getLastActivityTimestamp() {
        return Optional.ofNullable(this.lastActivityTimestamp);
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public boolean isIndexingWorkerActive() {
        return this.indexingWorkerActive;
    }

    public static class Builder {
        private QueuedEvent currentEvent;
        private String currentTaskDescription;
        private int delayedQueueSize;
        private boolean indexingWorkerActive;
        private Instant lastActivityTimestamp;
        private int queueSize;

        public SimpleIndexingThreadContext build() {
            return new SimpleIndexingThreadContext(this);
        }

        @Nonnull
        public Builder currentEvent(@Nullable QueuedEvent currentEvent) {
            this.currentEvent = currentEvent;
            return this;
        }

        @Nonnull
        public Builder currentTaskDescription(@Nullable String currentTaskDescription) {
            this.currentTaskDescription = currentTaskDescription;
            return this;
        }

        @Nonnull
        public Builder delayedQueueSize(int delayedQueueSize) {
            this.delayedQueueSize = delayedQueueSize;
            return this;
        }

        @Nonnull
        public Builder indexingWorkerActive(boolean indexingWorkerActive) {
            this.indexingWorkerActive = indexingWorkerActive;
            return this;
        }

        @Nonnull
        public Builder lastActivityTimestamp(@Nullable Instant lastActivityTimestamp) {
            this.lastActivityTimestamp = lastActivityTimestamp;
            return this;
        }

        @Nonnull
        public Builder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }
    }
}

