/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.monitoring.thread;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingProcess;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Objects;

public final class SimpleIndexingThreadDetails
implements IndexingThreadDetails {
    private final Instant capturedAt;
    private final IndexingProcess currentProcess;
    private final int delayedQueueSize;
    private final int queueSize;
    private final IndexingThreadState state;
    private final String threadName;

    private SimpleIndexingThreadDetails(Builder builder) {
        this.capturedAt = builder.capturedAt;
        this.currentProcess = builder.currentProcess;
        this.delayedQueueSize = builder.delayedQueueSize;
        this.queueSize = builder.queueSize;
        this.state = builder.state;
        this.threadName = builder.threadName;
    }

    @Override
    @Nonnull
    public Instant getCapturedAt() {
        return this.capturedAt;
    }

    @Override
    @Nullable
    public IndexingProcess getCurrentProcess() {
        return this.currentProcess;
    }

    @Override
    public int getDelayedQueueSize() {
        return this.delayedQueueSize;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    @Nonnull
    public IndexingThreadState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public String getThreadName() {
        return this.threadName;
    }

    public static class Builder {
        private final Instant capturedAt;
        private final IndexingThreadState state;
        private final String threadName;
        private IndexingProcess currentProcess;
        private int delayedQueueSize;
        private int queueSize;

        public Builder(@Nonnull IndexingThreadState state, @Nonnull String threadName) {
            this(Instant.now(), state, threadName);
        }

        public Builder(@Nonnull Instant capturedAt, @Nonnull IndexingThreadState state, @Nonnull String threadName) {
            this.capturedAt = Objects.requireNonNull(capturedAt, "capturedAt");
            this.state = Objects.requireNonNull(state, "state");
            this.threadName = Objects.requireNonNull(threadName, "threadName");
        }

        @Nonnull
        public IndexingThreadDetails build() {
            return new SimpleIndexingThreadDetails(this);
        }

        @Nonnull
        public Builder currentProcess(@Nullable IndexingProcess currentProcess) {
            this.currentProcess = currentProcess;
            return this;
        }

        @Nonnull
        public Builder delayedQueueSize(int delayedQueueSize) {
            this.delayedQueueSize = delayedQueueSize;
            return this;
        }

        @Nonnull
        public Builder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }
    }
}

