/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.migration.RestRepositorySelector;
import com.atlassian.bitbucket.dmz.search.IndexingWorkerThreadManager;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.search.common.cluster.ClusterJobManager;
import com.atlassian.bitbucket.internal.search.indexing.audit.SearchFullSynchronisationAuditEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.jobs.SearchSynchronizeJob;
import com.atlassian.bitbucket.internal.search.indexing.jobs.StartupChecksJob;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.BrokenRepositoryService;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexingWorkerRestartRequest;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.event.api.EventPublisher;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@Tag(name="Search")
public class IndexingResource {
    private static final String STATE_IDLE = "IDLE";
    private static final String STATE_INDEXING = "INDEXING";
    private final BrokenRepositoryService brokenRepositoryService;
    private final ClusterJobManager clusterJobManager;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final IndexEventQueueProcessor processor;
    private final RepositoryService repositoryService;
    private final IndexingWorkerThreadManager threadManager;

    @Inject
    public IndexingResource(BrokenRepositoryService brokenRepositoryService, ClusterJobManager clusterJobManager, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, PermissionValidationService permissionValidationService, IndexEventQueueProcessor processor, RepositoryService repositoryService, IndexingWorkerThreadManager threadManager) {
        this.brokenRepositoryService = brokenRepositoryService;
        this.clusterJobManager = clusterJobManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.processor = processor;
        this.repositoryService = repositoryService;
        this.threadManager = threadManager;
    }

    @Operation(description="Forces the provided repositories to reindex with the search server. For each repository the current index on the search server will be deleted and it will be queued for re-indexing. Note that this can result in diminished instance performance as deleting and reindexing a large repository can take some time", summary="Re-indexes the search index of the provided list of repositories")
    @ResponseDocs(value={@ResponseDoc(documentation="", responseCode=204), @ResponseDoc(documentation="Some or all of the provided repositories could not be located. See the error message for repositories that could not be located.", restError=true, responseCode=400), @ResponseDoc(documentation="Some or all of the provided repositories could not be queued for re-indexing. Partial completion of the request may have occurred. See the error message for repository repositories that could not be queued", restError=true, responseCode=409), @ResponseDoc(documentation="Insufficient permissions for the current user. Requires SYS_ADMIN permissions.", restError=true, responseCode=401)})
    @RequestBody(content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestRepositorySelector.class)))})
    @POST
    @Path(value="/reindex")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response reindexRepositories(List<RestRepositorySelector> selectors) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        if (selectors == null || selectors.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.rest.repositories.none.provided", new Object[0]));
        }
        ArrayList invalidRepositories = new ArrayList();
        List<Repository> repositories = selectors.stream().map(selector -> {
            Repository repository = this.repositoryService.getBySlug(selector.getProjectKey(), selector.getSlug());
            if (repository == null) {
                invalidRepositories.add(String.format("%s/%s", selector.getProjectKey(), selector.getSlug()));
            }
            return repository;
        }).filter(Objects::nonNull).toList();
        if (!invalidRepositories.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.search.reindexing.validation.error", new Object[]{invalidRepositories}));
        }
        this.brokenRepositoryService.reindexRepositories(repositories);
        return Response.ok().build();
    }

    @Operation(description="Restarts the search indexing worker thread. By default this will cause the currently running queue event to be terminated. This behaviour can be modified by providing the graceful shutdown flag in the request.", summary="Restarts the search indexing worker thread")
    @ResponseDocs(value={@ResponseDoc(documentation="", responseCode=200), @ResponseDoc(documentation="Insufficient permissions for the current user. Requires SYS_ADMIN permissions.", restError=true, responseCode=401)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestIndexingWorkerRestartRequest.class))})
    @POST
    @Path(value="/restart")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response restartIndexingThreadWorker(RestIndexingWorkerRestartRequest request) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        boolean doGraceful = request.isGracefulShutdown();
        if (request.isWaitForRestart()) {
            this.restartIndexingWorkerThread(doGraceful);
        } else {
            this.executorService.execute(() -> this.restartIndexingWorkerThread(doGraceful));
        }
        return Response.ok().build();
    }

    @Hidden
    @Path(value="/status")
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response status() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        int delayQueueSize = this.processor.getDelayQueueSize();
        int eventQueueSize = this.processor.getEventQueueSize();
        HashMap<String, Integer> queues = new HashMap<String, Integer>();
        queues.put("delay", delayQueueSize);
        queues.put("event", eventQueueSize);
        HashMap<String, Object> responseObject = new HashMap<String, Object>();
        responseObject.put("queues", queues);
        responseObject.put("status", eventQueueSize > 0 || delayQueueSize > 0 ? STATE_INDEXING : STATE_IDLE);
        return Response.ok(responseObject).build();
    }

    @Hidden
    @Path(value="/sync")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response sync() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.runSynchronization();
        this.eventPublisher.publish((Object)new SearchFullSynchronisationAuditEvent(this));
        return Response.ok().build();
    }

    private void restartIndexingWorkerThread(boolean doGraceful) {
        this.threadManager.suspendIndexing(!doGraceful);
        this.threadManager.resumeIndexing();
    }

    private void runSynchronization() {
        this.clusterJobManager.unscheduleAdHocJob(StartupChecksJob.class);
        this.clusterJobManager.unscheduleAdHocJob(SearchSynchronizeJob.class);
        this.clusterJobManager.scheduleAdHocJob(Instant.now(), SearchSynchronizeJob.class);
    }
}

