/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.search.indexing.audit.SearchRepositorySynchronisationAuditEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.IndexingQueueMonitoringService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetailsService;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexingIsRepositoryQueued;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestRepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestRepositoryIndexingQueueDetails;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.event.api.EventPublisher;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json"})
@Singleton
@Tag(name="Search")
public class RepositoryIndexingResource {
    private final EventPublisher eventPublisher;
    private final IndexingQueueMonitoringService indexingQueueMonitoringService;
    private final PermissionValidationService permissionValidationService;
    private final IndexEventQueueProcessor processor;
    private final RepositoryIndexingDetailsService repositoryIndexingDetailsService;

    @Inject
    public RepositoryIndexingResource(EventPublisher eventPublisher, IndexingQueueMonitoringService indexingQueueMonitoringService, PermissionValidationService permissionValidationService, IndexEventQueueProcessor processor, RepositoryIndexingDetailsService repositoryIndexingDetailsService) {
        this.eventPublisher = eventPublisher;
        this.indexingQueueMonitoringService = indexingQueueMonitoringService;
        this.permissionValidationService = permissionValidationService;
        this.processor = processor;
        this.repositoryIndexingDetailsService = repositoryIndexingDetailsService;
    }

    @Operation(description="Retrieve the search indexing details of a repository. This includes the current status, and the commit and timestamp of the last successful index.\n\nIf the status is <b>BROKEN</b> then the <code>indexingError</code> will also be included in the response. The <code>indexingError</code> is the error that the application encountered during the last failed indexing attempt before the repository was removed from indexing.\n\nThe authenticated user must have <b>REPO_ADMIN</b> permission for the specified repository to call this resource.", summary="Get repository search indexing details.")
    @ResponseDocs(value={@ResponseDoc(documentation="The indexing details of the repository.", representation=RestRepositoryIndexingDetails.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The repository does not exist.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDetails(@BeanParam RepositoryResolver repositoryResolver) {
        RepositoryIndexingDetails repositoryIndexingDetails = this.repositoryIndexingDetailsService.getIndexingDetails(repositoryResolver.getRepository());
        return Response.ok((Object)((Object)new RestRepositoryIndexingDetails(repositoryIndexingDetails))).build();
    }

    @Operation(description="Provides a snapshot of the queue status for a specified repository at the time of the request.\n\nThe authenticated user must have <b>REPO_ADMIN</b> permission for the specified repository to call this resource.", summary="Retrieve detailed queue information for a repository")
    @ResponseDocs(value={@ResponseDoc(documentation="A snapshot containing the indexing queue information for the repository.", representation=RestRepositoryIndexingQueueDetails.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="/indexing-queue-details")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getQueueDetails(@BeanParam RepositoryResolver repositoryResolver) {
        List<RestRepositoryIndexingQueueDetails> queueDetails = this.indexingQueueMonitoringService.getIndexingQueueDetails(repositoryResolver.getRepository()).stream().map(RestRepositoryIndexingQueueDetails::new).toList();
        return Response.ok(queueDetails).build();
    }

    @Operation(description="Checks if a repository has been queued for indexing.\n\nThe authenticated user must have <b>REPO_ADMIN</b> permission for the specified repository to call this resource.", summary="Checks if a repository has been queued for indexing.")
    @ResponseDocs(value={@ResponseDoc(documentation="Returns true if the repository has been queued for indexing.\n\nIn a clustered environment, this will return true if the repository has been queued for indexing on <i>any</i> node.", representation=RestIndexingIsRepositoryQueued.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to view the repository.", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="/indexing-queued-status")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response indexingQueuedStatus(@BeanParam RepositoryResolver repositoryResolver) {
        RestIndexingIsRepositoryQueued repositoryQueued = new RestIndexingIsRepositoryQueued(this.indexingQueueMonitoringService.isRepositoryQueued(repositoryResolver.getRepository()));
        return Response.ok((Object)((Object)repositoryQueued)).build();
    }

    @Hidden
    @Path(value="/sync")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response syncRepo(@BeanParam RepositoryResolver repositoryResolver) {
        this.permissionValidationService.validateForRepository(repositoryResolver.getRepository(), Permission.REPO_ADMIN);
        if (this.processor.queueEvent(((ReindexRepositoryFilesEvent.Builder)ReindexRepositoryFilesEvent.builder().repositoryId(repositoryResolver.getRepository().getId())).build())) {
            this.eventPublisher.publish((Object)new SearchRepositorySynchronisationAuditEvent(this, repositoryResolver.getRepository(), true));
            return Response.ok().build();
        }
        this.eventPublisher.publish((Object)new SearchRepositorySynchronisationAuditEvent(this, repositoryResolver.getRepository(), false));
        return Response.serverError().build();
    }
}

