/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.event.EventType;
import com.atlassian.bitbucket.internal.search.indexing.event.QueuedEvent;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexEventMetadata;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexEventMetadataInitializer;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

@Schema(accessMode=Schema.AccessMode.READ_ONLY)
public class RestIndexEvent
extends RestMapEntity {
    private final String EVENT_METADATA = "eventMetadata";
    private final String EVENT_TYPE = "eventType";
    private final String RETRIES = "retries";

    public RestIndexEvent() {
    }

    public RestIndexEvent(Map<String, ?> values) {
        super(values);
    }

    public RestIndexEvent(@Nonnull QueuedEvent queuedEvent) {
        Objects.requireNonNull(queuedEvent, "queuedEvent");
        this.put("eventMetadata", (Object)queuedEvent.getEvent().accept(new RestIndexEventMetadataInitializer()));
        this.put("eventType", (Object)queuedEvent.getEvent().getEventType());
        this.put("retries", queuedEvent.getRetries());
    }

    public static RestIndexEvent valueOf(@Nullable Object value) {
        if (value instanceof RestIndexEvent) {
            return (RestIndexEvent)((Object)value);
        }
        if (value instanceof Map) {
            return new RestIndexEvent((Map)value);
        }
        return null;
    }

    @Schema(description="Retrieves the metadata associated with the index event. The content of this metadata is variable and depends on the event type. It may include identifiers such as repository ID, project ID, or user ID, among other relevant details.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestIndexEventMetadata getEventMetadata() {
        return RestIndexEventMetadata.valueOf(this.get("eventMetadata"));
    }

    @Schema(description="Retrieves the type of the event, indicating the entity (such as project, repository, or user) that triggered the indexing operation.", requiredMode=Schema.RequiredMode.REQUIRED)
    public EventType getEventType() {
        return (EventType)this.getEnumProperty("eventType", EventType.class);
    }

    @Schema(description="Retrieves the count of how many times this event has been retried due to previous failures or exceptions.", requiredMode=Schema.RequiredMode.REQUIRED)
    public int getRetries() {
        return this.getIntProperty("retries");
    }
}

