/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventVisitor;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ReindexRepositoryFilesEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentIndirectlyModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryPropertiesModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.UserDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexEventMetadata;
import java.util.Map;

public class RestIndexEventMetadataInitializer
implements IndexEventVisitor<RestIndexEventMetadata> {
    private static final String PROJECT_ID = "projectId";
    private static final String REPOSITORY_ID = "repositoryId";
    private static final String USERNAME = "username";

    @Override
    public RestIndexEventMetadata visit(ProjectCreatedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(PROJECT_ID, event.getProjectId()));
    }

    @Override
    public RestIndexEventMetadata visit(ProjectDeletedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(PROJECT_ID, event.getProjectId()));
    }

    @Override
    public RestIndexEventMetadata visit(ProjectModifiedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(PROJECT_ID, event.getProjectId()));
    }

    @Override
    public RestIndexEventMetadata visit(ReindexRepositoryFilesEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryContentDeletedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryContentIndirectlyModifiedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryContentModifiedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryCreatedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryDeletedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryModifiedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(RepositoryPropertiesModifiedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(REPOSITORY_ID, event.getRepositoryId()));
    }

    @Override
    public RestIndexEventMetadata visit(UserDeletedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(USERNAME, event.getUsername()));
    }

    @Override
    public RestIndexEventMetadata visit(UserCreatedIndexEvent event) {
        return new RestIndexEventMetadata(Map.of(USERNAME, event.getUser().getName()));
    }
}

