/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingProcess;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexEvent;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

@Schema(accessMode=Schema.AccessMode.READ_ONLY)
public class RestIndexingProcess
extends RestMapEntity {
    private static final String CURRENT_TASK = "currentTask";
    private static final String EVENT = "event";

    public RestIndexingProcess() {
    }

    public RestIndexingProcess(Map<String, ?> values) {
        super(values);
    }

    public RestIndexingProcess(@Nonnull IndexingProcess indexingProcess) {
        Objects.requireNonNull(indexingProcess, "indexingProcess");
        this.put(CURRENT_TASK, indexingProcess.getCurrentTask());
        this.put(EVENT, (Object)new RestIndexEvent(indexingProcess.getEvent()));
    }

    public static RestIndexingProcess valueOf(@Nullable Object value) {
        if (value instanceof RestIndexingProcess) {
            return (RestIndexingProcess)((Object)value);
        }
        if (value instanceof Map) {
            return new RestIndexingProcess((Map)value);
        }
        return null;
    }

    @Schema(description="The current task description that the indexing worker is executing.", example="Indexing file: 'example.txt'", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getCurrentTask() {
        return this.getStringProperty(CURRENT_TASK);
    }

    @Schema(description="The event that is currently being processed by the indexing worker.", requiredMode=Schema.RequiredMode.REQUIRED)
    public RestIndexEvent getEvent() {
        return RestIndexEvent.valueOf(this.get(EVENT));
    }
}

