/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadDetails;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexingProcess;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexingThreadState;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Schema(accessMode=Schema.AccessMode.READ_ONLY)
public class RestIndexingThreadDetails
extends RestMapEntity {
    private static final String CAPTURED_AT = "capturedAt";
    private static final String CURRENT_PROCESS = "currentProcess";
    private static final String DELAYED_QUEUE_SIZE = "delayedQueueSize";
    private static final String QUEUE_SIZE = "queueSize";
    private static final String STATE = "state";
    private static final String THREAD_NAME = "threadName";

    public RestIndexingThreadDetails() {
    }

    public RestIndexingThreadDetails(@Nonnull IndexingThreadDetails indexingThreadDetails) {
        Objects.requireNonNull(indexingThreadDetails, "indexingThreadDetails");
        this.put(CAPTURED_AT, indexingThreadDetails.getCapturedAt().toEpochMilli());
        if (indexingThreadDetails.getCurrentProcess() != null) {
            this.put(CURRENT_PROCESS, (Object)new RestIndexingProcess(indexingThreadDetails.getCurrentProcess()));
        }
        this.put(DELAYED_QUEUE_SIZE, indexingThreadDetails.getDelayedQueueSize());
        this.put(QUEUE_SIZE, indexingThreadDetails.getQueueSize());
        this.put(STATE, (Object)new RestIndexingThreadState(indexingThreadDetails.getState()));
        this.put(THREAD_NAME, indexingThreadDetails.getThreadName());
    }

    @Schema(description="Returns the timestamp indicating when the current thread details were captured.", example="1732136412902", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getCapturedAt() {
        return this.getLongProperty(CAPTURED_AT);
    }

    @Schema(description="A snapshot of the current process being executed by the indexing worker.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public RestIndexingProcess getCurrentProcess() {
        return RestIndexingProcess.valueOf(this.get(CURRENT_PROCESS));
    }

    @Schema(description="The number of items in the delayed queue. This queue contains retries that have been scheduled with an exponential backoff delay. The retries are for operations that previously failed in the main queue.", requiredMode=Schema.RequiredMode.REQUIRED)
    public int getDelayedQueueSize() {
        return this.getIntProperty(DELAYED_QUEUE_SIZE);
    }

    @Schema(description="The number of items currently in the main queue.", requiredMode=Schema.RequiredMode.REQUIRED)
    public int getQueueSize() {
        return this.getIntProperty(QUEUE_SIZE);
    }

    @Schema(description="Represents the state of an indexing thread.", requiredMode=Schema.RequiredMode.REQUIRED)
    public RestIndexingThreadState getState() {
        return RestIndexingThreadState.valueOf(this.get(STATE));
    }
}

