/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadState;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;

@Schema(accessMode=Schema.AccessMode.READ_ONLY)
public class RestIndexingThreadState
extends RestMapEntity {
    private static final String CODE = "code";
    private static final String DESCRIPTION = "description";

    public RestIndexingThreadState() {
    }

    public RestIndexingThreadState(@Nonnull IndexingThreadState indexingThreadState) {
        Objects.requireNonNull(indexingThreadState, "indexingThreadState");
        this.put(CODE, (Object)indexingThreadState.getCode());
        this.putIfNotNull(DESCRIPTION, indexingThreadState.getDescription());
    }

    private RestIndexingThreadState(Map<String, Object> values) {
        super(values);
    }

    public static RestIndexingThreadState valueOf(@Nullable Object value) {
        if (value instanceof RestIndexingThreadState) {
            return (RestIndexingThreadState)((Object)value);
        }
        if (value instanceof Map) {
            return new RestIndexingThreadState((Map)value);
        }
        return null;
    }

    @Schema(description="The current code representing the state of the indexing thread", requiredMode=Schema.RequiredMode.REQUIRED)
    public IndexingThreadState.Code getCode() {
        return (IndexingThreadState.Code)this.getEnumProperty(CODE, IndexingThreadState.Code.class);
    }

    @Schema(description="Additional detail about the current state, meant for informational purposes only.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }
}

