/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

public class RestRepositoryIndexingDetails
extends RestMapEntity {
    public static final String INDEXING_ERROR = "indexingError";
    public static final String LAST_INDEXED_COMMIT_ID = "lastIndexedCommitId";
    public static final String LAST_INDEXED_TIMESTAMP = "lastIndexedTimestamp";
    public static final String PROJECT_KEY = "projectKey";
    public static final String REPOSITORY_SLUG = "repositorySlug";
    public static final String STATUS = "status";

    public RestRepositoryIndexingDetails() {
    }

    public RestRepositoryIndexingDetails(RepositoryIndexingDetails repositoryIndexingDetails) {
        this.putIfNotNull(LAST_INDEXED_COMMIT_ID, repositoryIndexingDetails.getLastIndexedCommitId());
        this.putIfNotNull(INDEXING_ERROR, repositoryIndexingDetails.getIndexingError());
        this.put(PROJECT_KEY, repositoryIndexingDetails.getProjectKey());
        this.put(REPOSITORY_SLUG, repositoryIndexingDetails.getRepositorySlug());
        this.put(STATUS, (Object)repositoryIndexingDetails.getStatus());
        if (repositoryIndexingDetails.getLastIndexedTimestamp() != null) {
            this.put(LAST_INDEXED_TIMESTAMP, repositoryIndexingDetails.getLastIndexedTimestamp().toEpochMilli());
        }
    }

    private RestRepositoryIndexingDetails(Map<String, Object> values) {
        super(values);
    }

    public static RestRepositoryIndexingDetails valueOf(Object value) {
        if (value instanceof RestRepositoryIndexingDetails) {
            return (RestRepositoryIndexingDetails)((Object)value);
        }
        if (value instanceof Map) {
            return new RestRepositoryIndexingDetails((Map)value);
        }
        return null;
    }

    @Schema(description="Additional detail about the <b>BROKEN</b> status if available, meant for informational purposes only. This nullable, free-form text field should not be used for automation; rely on status instead.", example="Indexing timed out.", accessMode=Schema.AccessMode.READ_ONLY, requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getIndexingError() {
        return this.getStringProperty(INDEXING_ERROR);
    }

    @Schema(description="The commit hash of the last indexed commit in the repository.", example="abcdef0123abcdef4567abcdef8987abcdef6543", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public String getLastIndexedCommitId() {
        return this.getStringProperty(LAST_INDEXED_COMMIT_ID);
    }

    @Schema(description="The timestamp in epoch milliseconds of the last time the repository successfully was indexed", example="1732022086", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public long getLastIndexedTimestamp() {
        return this.getLongProperty(LAST_INDEXED_TIMESTAMP);
    }

    @Schema(description="The project key that the repository belongs to", example="PROJECT_1", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getProjectKey() {
        return this.getStringProperty(PROJECT_KEY);
    }

    @Schema(description="The repository slug", example="rep_1", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getRepositorySlug() {
        return this.getStringProperty(REPOSITORY_SLUG);
    }

    @Schema(description="The current indexing status of the repository.", allowableValues={"BROKEN", "INDEXED", "INDEXING", "UNKNOWN"}, requiredMode=Schema.RequiredMode.REQUIRED)
    public String getStatus() {
        return this.getStringProperty(STATUS);
    }
}

