/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.bitbucket.internal.search.indexing.monitoring.queue.RepositoryIndexingQueueDetails;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.Optional;

@Schema(accessMode=Schema.AccessMode.READ_ONLY)
public class RestRepositoryIndexingQueueDetails
extends RestMapEntity {
    private static final String CAPTURED_AT = "capturedAt";
    private static final String NODE_ID = "nodeId";
    private static final String QUEUED = "queued";
    private static final String QUEUED_AT = "queuedAt";

    public RestRepositoryIndexingQueueDetails() {
    }

    public RestRepositoryIndexingQueueDetails(Map<String, ?> values) {
        super(values);
    }

    public RestRepositoryIndexingQueueDetails(RepositoryIndexingQueueDetails queueDetails) {
        this.put(CAPTURED_AT, queueDetails.getCapturedAt().toEpochMilli());
        this.put(NODE_ID, queueDetails.getNodeId());
        this.put(QUEUED, queueDetails.isQueued());
        queueDetails.getQueuedAt().ifPresent(queuedAt -> this.put(QUEUED_AT, queuedAt));
    }

    @Schema(description="The timestamp indicating when the current queue details were captured.", example="1732136412902", requiredMode=Schema.RequiredMode.REQUIRED)
    public long getCapturedAt() {
        return this.getLongProperty(CAPTURED_AT);
    }

    @Schema(description="The ID of the node associated with the indexing queue.", example="58ed5b70-e8ef-4d4e-be13-88221650a51b", requiredMode=Schema.RequiredMode.REQUIRED)
    public String getNodeId() {
        return this.getStringProperty(NODE_ID);
    }

    @Schema(description="Gets the time at which the repository was added to the indexing queue. If the repository is not present in the queue, this will be empty.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    public Optional<Long> getQueuedAt() {
        long queuedAt = this.getLongProperty(QUEUED_AT);
        return queuedAt == -1L ? Optional.empty() : Optional.of(queuedAt);
    }

    @Schema(description="Indicates whether the repository is currently queued for indexing.", requiredMode=Schema.RequiredMode.REQUIRED)
    public boolean isQueued() {
        return this.getBoolProperty(QUEUED);
    }
}

