/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.annotations.security.SystemAdminOnly;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.BrokenRepositoryService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.DefaultBrokenRepositoryService;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.repository.RepositoryIndexingDetails;
import com.atlassian.bitbucket.internal.search.indexing.monitoring.thread.IndexingThreadMonitoringService;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestBrokenIndexStatusRepository;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestIndexingThreadDetails;
import com.atlassian.bitbucket.internal.search.indexing.rest.RestRepositoryIndexingDetails;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@Singleton
@SystemAdminOnly
@Path(value="support-info")
@Tag(name="Search")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchSupportResource {
    private final BrokenRepositoryService brokenRepositoryService;
    private final IndexingThreadMonitoringService monitoringService;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public SearchSupportResource(DefaultBrokenRepositoryService brokenRepositoryService, IndexingThreadMonitoringService monitoringService, PermissionValidationService permissionValidationService) {
        this.brokenRepositoryService = brokenRepositoryService;
        this.monitoringService = monitoringService;
        this.permissionValidationService = permissionValidationService;
    }

    @Operation(description="Retrieve repositories which are in the <code>BROKEN</code> indexing state.\n\nWhen a repository has a <code>BROKEN</code> indexing status it will no longer attempt to be re-indexed by the system, even when changes are made to its code. A repository is given a <code>BROKEN</code> indexing status when it fails to index too many times.\n\nThe authenticated user must have <b>SYS_ADMIN</b> permission to call this resource.", summary="Retrieve a paged list of repositories which have exceeded the configured maximum indexing retries.")
    @ResponseDocs(value={@ResponseDoc(documentation="Page of repositories where <code>STATE = BROKEN<code>", representation=RestBrokenIndexStatusRepository.class, paged=true, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to call this resource.", restError=true, responseCode=401), @ResponseDoc(documentation="The supplied page limit exceeds the allowed maximum of 1000", restError=true, responseCode=400)})
    @GET
    @Path(value="/broken-index-status-repos")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getBrokenIndexStatusRepos(@BeanParam PageRequestResolver pageRequestResolver) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        Page<RepositoryIndexingDetails> results = this.brokenRepositoryService.getBrokenRepositoryIndexingDetails(pageRequestResolver.getPageRequest());
        return Response.ok((Object)new RestPage(results, RestRepositoryIndexingDetails::new)).build();
    }

    @Operation(description="Fetches a snapshot of the indexing thread details at the moment the request is processed. Note that the result represents the thread's status at a specific point in time, and the state may have changed by the time this endpoint responds.", summary="Retrieve a snapshot of the indexing thread details.")
    @ApiResponses(value={@ApiResponse(description="A snapshot containing the details of the indexing threads.", responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=RestIndexingThreadDetails.class)))}), @ApiResponse(description="Insufficient permissions for the current user. Requires SYS_ADMIN permissions.", responseCode="401", content={@Content(schema=@Schema(implementation=RestErrors.class), mediaType="application/json")})})
    @GET
    @Path(value="indexing-thread-snapshot")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getIndexingThreadSnapshot() {
        List<RestIndexingThreadDetails> threadDetails = this.monitoringService.getThreadDetails().stream().map(RestIndexingThreadDetails::new).toList();
        return Response.ok(threadDetails).build();
    }
}

