/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.indexing.event.IndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.IndexEventQueueProcessor;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.IndexEventPublisher;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultIndexEventPublisher
implements IndexEventPublisher {
    private static final int MAX_EVENT_RETRIES = 5;
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexEventPublisher.class);
    private final IndexEventQueueProcessor eventProcessor;

    @Autowired
    public DefaultIndexEventPublisher(IndexEventQueueProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    @Override
    public void fireEvent(IndexEvent event) {
        int retries = 1;
        while (!this.eventProcessor.queueEvent(event, Duration.ofMinutes(1L))) {
            log.warn("Retry {}/{} - Unable to enqueue event: [{}]", new Object[]{retries, 5, event});
            if (retries++ < 5) continue;
        }
    }
}

