/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import jakarta.annotation.Nonnull;

public class EntityWithLocation<T> {
    private final T entity;
    private Location location;

    public EntityWithLocation(@Nonnull Location location, @Nonnull T entity) {
        this.location = location;
        this.entity = entity;
    }

    public static <T> EntityWithLocation<T> of(Location origin, T entity) {
        return new EntityWithLocation<T>(origin, entity);
    }

    public void foundIn(@Nonnull Location location) {
        if (this.location != Location.BOTH && this.location != location) {
            this.location = Location.BOTH;
        }
    }

    public T getEntity() {
        return this.entity;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isIn(@Nonnull Location location) {
        return this.location == Location.BOTH || this.location == location;
    }

    public boolean isOnlyIn(@Nonnull Location location) {
        return this.location == location;
    }

    public String toString() {
        return "EntityWithLocation{, location=" + String.valueOf((Object)this.location) + ", entity=" + String.valueOf(this.entity) + "}";
    }

    public static enum Location {
        SEARCH,
        DATABASE,
        BOTH;

    }
}

