/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.indexing.event.ProjectCreatedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.ProjectModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.ComparisonCallback;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.IndexEventPublisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="projectMetadataCallback")
public class ProjectMetadataCallback
implements ComparisonCallback<Integer> {
    private final IndexEventPublisher indexEventPublisher;

    @Autowired
    public ProjectMetadataCallback(IndexEventPublisher indexEventPublisher) {
        this.indexEventPublisher = indexEventPublisher;
    }

    @Override
    public void inBothSources(Integer projectId) {
        this.indexEventPublisher.fireEvent(((ProjectModifiedIndexEvent.Builder)ProjectModifiedIndexEvent.builder().projectId(projectId)).build());
    }

    @Override
    public void inSearchSourceOnly(Integer projectId) {
        this.indexEventPublisher.fireEvent(((ProjectDeletedIndexEvent.Builder)ProjectDeletedIndexEvent.builder().projectId(projectId)).build());
    }

    @Override
    public void inServerSourceOnly(Integer projectId) {
        this.indexEventPublisher.fireEvent(((ProjectCreatedIndexEvent.Builder)ProjectCreatedIndexEvent.builder().projectId(projectId)).build());
    }
}

