/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentDeletedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.event.RepositoryContentModifiedIndexEvent;
import com.atlassian.bitbucket.internal.search.indexing.filter.IndexFilterService;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.ComparisonCallback;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.IndexEventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryContentCallback")
public class RepositoryContentCallback
implements ComparisonCallback<Integer> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryContentCallback.class);
    private final IndexEventPublisher indexEventPublisher;
    private final IndexFilterService indexFilterService;

    @Autowired
    public RepositoryContentCallback(IndexEventPublisher indexEventPublisher, IndexFilterService indexFilterService) {
        this.indexEventPublisher = indexEventPublisher;
        this.indexFilterService = indexFilterService;
    }

    @Override
    public void inBothSources(Integer repositoryId) {
        log.debug("Repository [{}] found in both sources.", (Object)repositoryId);
        if (this.indexFilterService.shouldProcess(this.modifiedContentEventForRepository(repositoryId))) {
            log.debug("Repository [{}] will not be filtered, updating content", (Object)repositoryId);
            this.fireRepositoryContentModifiedEvent(repositoryId);
        } else {
            log.debug("Repository [{}] has been filtered on an indexing sync event. The contents of this repository will be removed from the index", (Object)repositoryId);
            this.fireRepositoryContentDeletedEvent(repositoryId);
        }
    }

    @Override
    public void inSearchSourceOnly(Integer repositoryId) {
        this.fireRepositoryContentDeletedEvent(repositoryId);
    }

    @Override
    public void inServerSourceOnly(Integer repositoryId) {
        this.fireRepositoryContentModifiedEvent(repositoryId);
    }

    private void fireRepositoryContentDeletedEvent(int repositoryId) {
        this.indexEventPublisher.fireEvent(((RepositoryContentDeletedIndexEvent.Builder)RepositoryContentDeletedIndexEvent.builder().repositoryId(repositoryId)).build());
    }

    private void fireRepositoryContentModifiedEvent(int repositoryId) {
        this.indexEventPublisher.fireEvent(this.modifiedContentEventForRepository(repositoryId));
    }

    private RepositoryContentModifiedIndexEvent modifiedContentEventForRepository(int repositoryId) {
        return ((RepositoryContentModifiedIndexEvent.Builder)RepositoryContentModifiedIndexEvent.builder().repositoryId(repositoryId)).isSynchronizationEvent(true).build();
    }
}

