/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.EntityWithLocation;
import com.atlassian.bitbucket.internal.search.indexing.util.ElderScroll;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.search.Hit;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import rx.Observable;

public class SearchEntitySource<T> {
    private static final Duration SCROLL_ID_DURATION = Duration.ofMinutes(1L);
    private final SearchClient searchClient;
    private final Function<Hit, Boolean> filter;
    private final Function<Hit, T> hitToEntity;
    private final MappingType mappingType;
    private final int pageSize;

    public SearchEntitySource(Builder<T> builder) {
        this.searchClient = Objects.requireNonNull(builder.searchClient, "builder.searchClient");
        this.hitToEntity = Objects.requireNonNull(builder.hitToEntity, "builder.hitToEntity");
        this.mappingType = Objects.requireNonNull(builder.mappingType, "builder.mappingType");
        this.pageSize = builder.pageSize;
        this.filter = builder.filter;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Nonnull
    public Observable<EntityWithLocation<T>> streamEntities() {
        SearchSourceBuilder searchSourceBuilder = ES.searchSource().sort("_doc").source(false).page(ES.page().size(this.pageSize).build());
        Observable search = new ElderScroll(this.searchClient).search(searchSourceBuilder, this.mappingType, SCROLL_ID_DURATION);
        if (this.filter != null) {
            search = search.filter(this.filter::apply);
        }
        return search.map(hit -> EntityWithLocation.of(EntityWithLocation.Location.SEARCH, this.hitToEntity.apply((Hit)hit)));
    }

    public static class Builder<T> {
        private SearchClient searchClient;
        private Function<Hit, Boolean> filter;
        private Function<Hit, T> hitToEntity;
        private MappingType mappingType;
        private int pageSize;

        @Nonnull
        public SearchEntitySource<T> build() {
            return new SearchEntitySource(this);
        }

        @Nonnull
        public Builder<T> searchClient(@Nonnull SearchClient value) {
            this.searchClient = Objects.requireNonNull(value, "searchClient");
            return this;
        }

        @Nonnull
        public Builder<T> filter(@Nonnull Function<Hit, Boolean> value) {
            this.filter = Objects.requireNonNull(value, "filter");
            return this;
        }

        @Nonnull
        public Builder<T> hitToEntity(@Nonnull Function<Hit, T> value) {
            this.hitToEntity = Objects.requireNonNull(value, "hitToEntity");
            return this;
        }

        @Nonnull
        public Builder<T> mappingType(@Nonnull MappingType value) {
            this.mappingType = Objects.requireNonNull(value, "mappingType");
            return this;
        }

        @Nonnull
        public Builder<T> pageSize(int value) {
            this.pageSize = value;
            return this;
        }
    }
}

