/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.indexing.syncutil.EntityWithLocation;
import java.util.Objects;
import java.util.function.Function;
import rx.Observable;

public class ServerEntitySource<T, E> {
    private final Observable<E> dbObservable;
    private final Function<E, T> dbToEntity;

    private ServerEntitySource(Builder<T, E> builder) {
        this.dbObservable = Objects.requireNonNull(builder.dbObservable, "builder.dbObservable");
        this.dbToEntity = Objects.requireNonNull(builder.dbToEntity, "builder.dbToEntity");
    }

    public static <T, E> Builder<T, E> builder() {
        return new Builder();
    }

    public Observable<EntityWithLocation<T>> streamEntities() {
        return this.dbObservable.map(record -> EntityWithLocation.of(EntityWithLocation.Location.DATABASE, this.dbToEntity.apply(record)));
    }

    public static class Builder<T, E> {
        private Observable<E> dbObservable;
        private Function<E, T> dbToEntity;

        public ServerEntitySource<T, E> build() {
            return new ServerEntitySource(this);
        }

        public Builder<T, E> dbObservable(Observable<E> value) {
            this.dbObservable = Objects.requireNonNull(value, "dbObservable");
            return this;
        }

        public Builder<T, E> dbToEntity(Function<E, T> value) {
            this.dbToEntity = Objects.requireNonNull(value, "dbToEntity");
            return this;
        }
    }
}

