/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.syncutil;

import com.atlassian.bitbucket.internal.search.indexing.syncutil.ComparisonCallback;
import com.atlassian.bitbucket.internal.search.indexing.syncutil.EntityWithLocation;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.indexing.util.SearchUtil;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class StreamingComparator<E, I> {
    private static final Logger log = LoggerFactory.getLogger(StreamingComparator.class);
    private final Function<E, I> entityToIdentifier;
    private final Observable<EntityWithLocation<E>> searchEntities;
    private final Observable<EntityWithLocation<E>> serverEntities;

    private StreamingComparator(Builder<E, I> builder) {
        this.searchEntities = Objects.requireNonNull(builder.searchEntitySource, "builder.searchEntitySource");
        this.serverEntities = Objects.requireNonNull(builder.serverEntitySource, "builder.serverEntitySource");
        this.entityToIdentifier = Objects.requireNonNull(builder.entityToIdentifier, "builder.entityToIdentifier");
    }

    public static <E, I> Builder<E, I> builder() {
        return new Builder();
    }

    public boolean doComparison(ComparisonCallback<E> comparisonCallback) {
        ConcurrentHashMap accounting = new ConcurrentHashMap();
        AtomicBoolean serverSourceExhausted = new AtomicBoolean();
        AtomicBoolean searchSourceExhausted = new AtomicBoolean();
        Observable itemsProcessed = Observable.merge((Observable)this.serverEntities.doOnCompleted(() -> serverSourceExhausted.set(true)), (Observable)this.searchEntities.doOnCompleted(() -> searchSourceExhausted.set(true))).doOnNext(entity -> {
            I identifier = this.entityToIdentifier.apply(entity.getEntity());
            EntityWithLocation combinedEntity = (EntityWithLocation)accounting.get(identifier);
            if (combinedEntity == null) {
                combinedEntity = EntityWithLocation.of(entity.getLocation(), entity.getEntity());
            } else {
                combinedEntity.foundIn(entity.getLocation());
            }
            if (combinedEntity.isIn(EntityWithLocation.Location.BOTH)) {
                accounting.remove(identifier);
                comparisonCallback.inBothSources(combinedEntity.getEntity());
            } else if (searchSourceExhausted.get()) {
                comparisonCallback.inServerSourceOnly(combinedEntity.getEntity());
            } else if (serverSourceExhausted.get()) {
                comparisonCallback.inSearchSourceOnly(combinedEntity.getEntity());
            } else {
                accounting.put(identifier, combinedEntity);
            }
        }).count();
        return (Boolean)Observables.consumeSingle(itemsProcessed).fold(e -> {
            if (SearchUtil.isNetworkConnectException(e)) {
                log.error("An error occurred while attempting to connect to the search server. The search server instance/cluster is possibly unreachable");
            } else {
                log.error("Unable to perform job due to an unexpected error", (Throwable)e);
            }
            return false;
        }, itemCount -> {
            log.debug("Number of items compared: {}", itemCount);
            this.processComparisonResult(accounting, comparisonCallback);
            return true;
        });
    }

    private void processComparisonResult(Map<I, EntityWithLocation<E>> repositoryAccounting, ComparisonCallback<E> comparisonCallback) {
        repositoryAccounting.values().forEach(entity -> {
            if (entity.isOnlyIn(EntityWithLocation.Location.DATABASE)) {
                comparisonCallback.inServerSourceOnly(entity.getEntity());
            } else if (entity.isOnlyIn(EntityWithLocation.Location.SEARCH)) {
                comparisonCallback.inSearchSourceOnly(entity.getEntity());
            }
        });
    }

    public static class Builder<E, I> {
        public Function<E, I> entityToIdentifier;
        private Observable<EntityWithLocation<E>> searchEntitySource;
        private Observable<EntityWithLocation<E>> serverEntitySource;

        public StreamingComparator<E, I> build() {
            return new StreamingComparator(this);
        }

        public Builder<E, I> entityToIdentifier(@Nonnull Function<E, I> value) {
            this.entityToIdentifier = Objects.requireNonNull(value, "entityToIdentifier");
            return this;
        }

        public Builder<E, I> searchSource(@Nonnull Observable<EntityWithLocation<E>> searchEntitySource) {
            this.searchEntitySource = Objects.requireNonNull(searchEntitySource, "searchSourceBuilder");
            return this;
        }

        public Builder<E, I> serverSource(@Nonnull Observable<EntityWithLocation<E>> serverEntitySource) {
            this.serverEntitySource = Objects.requireNonNull(serverEntitySource, "serverEntitySource");
            return this;
        }
    }
}

