/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.upgrade;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexVersionMapping;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersionService;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersions;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.internal.search.version.SearchVersion;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.cluster.ClusterHealthRequestBuilder;
import com.atlassian.elasticsearch.client.content.ContentBuilder;
import com.atlassian.elasticsearch.client.content.ObjectContentBuilder;
import com.atlassian.elasticsearch.client.document.GetRequestBuilder;
import com.atlassian.elasticsearch.client.document.IndexRequestBuilder;
import com.atlassian.elasticsearch.client.indices.CreateIndexRequestBuilder;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import com.atlassian.elasticsearch.client.indices.IndexExistsBuilder;
import com.atlassian.elasticsearch.client.indices.MappingBuilder;
import com.atlassian.elasticsearch.client.request.AbstractRequestBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import rx.Observable;

@Service
public class DefaultIndexVersionService
implements IndexVersionService {
    private static final Set<Integer> ACCEPTED_RESPONSES = ImmutableSet.of((Object)200, (Object)404);
    private static final String INDEX_EXCEPTION_MESSAGE = "Unable to get index version from the search server with Http status code {0}. Reason: {1} ";
    private static final String INDEX_VERSION_ID = "index-version";
    private final SearchClient client;

    @Autowired
    public DefaultIndexVersionService(SearchClient client) {
        this.client = client;
    }

    @Override
    @Nonnull
    public Version getCurrentVersion() {
        GetRequestBuilder versionGetRequest = ES.index((String)IndexVersionMapping.type().indexName()).type().id(INDEX_VERSION_ID).get();
        return (Version)Observables.consumeSingle(this.client.execute(versionGetRequest)).fold(e -> {
            throw new IndexException("Unable to get index version from the search server", (Throwable)e);
        }, response -> {
            if (!ACCEPTED_RESPONSES.contains(response.getStatusCode())) {
                throw new IndexException(MessageFormat.format(INDEX_EXCEPTION_MESSAGE, response.getStatusCode(), response.getContent()));
            }
            return response.getSource().map(content -> content.getStringOrThrow(IndexVersionMapping.VERSION.fieldName())).map(Version::new).orElse(IndexVersions.VERSION_1);
        });
    }

    @Override
    public void setCurrentVersion(@Nonnull Version version) {
        SearchVersion searchVersion = this.getSearchVersion();
        ClusterHealthRequestBuilder requestBuilder = ES.clusterHealth().status("yellow").timeout("20s");
        this.execute("get cluster-health", (AbstractRequestBuilder)requestBuilder);
        this.createIndexVersionMapping(searchVersion);
        ObjectContentBuilder versionSource = ES.objectContent();
        versionSource.with(IndexVersionMapping.VERSION.fieldName(), Objects.requireNonNull(version, "version").toString());
        IndexRequestBuilder indexRequest = ES.index((String)IndexVersionMapping.type().indexName()).type().id(INDEX_VERSION_ID).index().source((ContentBuilder)versionSource);
        this.execute("update index-version", (AbstractRequestBuilder)indexRequest);
    }

    private void createIndexVersionMapping(SearchVersion searchVersion) {
        IndexExistsBuilder indexExistsBuilder = ES.index((String)IndexVersionMapping.type().indexName()).exists();
        Observable existsResponse = this.client.execute(indexExistsBuilder);
        Either indexExistsResponse = Observables.consumeSingle(existsResponse);
        indexExistsResponse.fold(error -> {
            throw new IndexException("Failed to check if index-state index exist's or not", (Throwable)error);
        }, response -> {
            if (!response.indexExists()) {
                CreateIndexRequestBuilder indexVersionBuilder = ES.index((String)IndexVersionMapping.type().indexName()).create().source((ContentBuilder)ES.createIndexSource().mapping((MappingBuilder)ES.mapping().field(IndexVersionMapping.VERSION.fieldName(), (FieldBuilder)ES.textField())));
                this.execute("create index-version", (AbstractRequestBuilder)indexVersionBuilder);
            }
            return null;
        });
    }

    private <T extends Response, B extends AbstractRequestBuilder<T, B>> void execute(String operation, AbstractRequestBuilder<T, B> requestBuilder) {
        Observables.consumeSingle(this.client.execute(requestBuilder)).fold(error -> {
            throw new IndexException(operation + " failed", (Throwable)error);
        }, response -> {
            if (!response.isStatusSuccess()) {
                throw new IndexException(operation + " yielded " + response.getStatusCode() + " response code.");
            }
            return Void.TYPE;
        });
    }

    private SearchVersion getSearchVersion() {
        return (SearchVersion)Observables.consumeSingle(this.client.getVersion()).fold(e -> {
            throw new IndexException("Unable to get version", (Throwable)e);
        }, Function.identity());
    }
}

