/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.upgrade;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersionService;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeService;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeTask;
import com.atlassian.bitbucket.util.Version;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultUpgradeService
implements UpgradeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpgradeService.class);
    private final SearchClient client;
    private final IndexVersionService indexVersionService;
    private final List<UpgradeTask> tasks;

    @Autowired
    public DefaultUpgradeService(SearchClient client, IndexVersionService indexVersionService, List<UpgradeTask> tasks) {
        this.client = client;
        this.indexVersionService = indexVersionService;
        this.tasks = tasks;
    }

    @Override
    public boolean upgrade() {
        Version currentVersion = this.indexVersionService.getCurrentVersion();
        List filteredTasks = this.tasks.stream().filter(task -> task.getVersion().compareTo(currentVersion) > 0).sorted(Comparator.comparing(UpgradeTask::getVersion)).collect(Collectors.toList());
        for (UpgradeTask task2 : filteredTasks) {
            String description = task2.getDescription();
            log.info("Executing upgrade task:[{}]", (Object)description);
            try {
                task2.execute(this.client);
            }
            catch (Exception e) {
                log.error("Upgrade task failed:[{}]", (Object)description, (Object)e);
                return false;
            }
            log.info("Successfully completed upgrade task:[{}]", (Object)description);
            this.upgradeVersion(task2);
        }
        return true;
    }

    public void upgradeVersion(UpgradeTask task) {
        Version version = task.getVersion();
        this.indexVersionService.setCurrentVersion(version);
        log.info("Upgraded index to version:[{}]", (Object)version);
    }
}

