/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.upgrade;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.ResponseStatus;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersions;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeTask;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.util.Version;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeTaskV4Point0
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTaskV4Point0.class);
    private final IndexAdministrationService indexAdministrationService;

    @Autowired
    public UpgradeTaskV4Point0(IndexAdministrationService indexAdministrationService) {
        this.indexAdministrationService = indexAdministrationService;
    }

    @Override
    public void execute(@Nonnull SearchClient client) {
        ArrayList errors = new ArrayList();
        Observables.consume(this.indexAdministrationService.recreateCodeSearchIndexes(), e -> {
            log.error("Failed to recreate index", e);
            errors.add(e.getMessage());
        }, created -> {
            if (created.getResponseStatus() != ResponseStatus.SUCCESS) {
                created.getErrorType().ifPresent(errors::add);
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to recreate indexes: ''{}''", errors);
            throw new IndexException("Failed to recreate index: " + String.valueOf(errors));
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Update path and filename fields for file search";
    }

    @Override
    @Nonnull
    public Version getVersion() {
        return IndexVersions.VERSION_4;
    }
}

