/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.upgrade;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.FileMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.common.mapping.RepositoryMapping;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.UpdateMappingRequest;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersions;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeTask;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeTaskV7Point0
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTaskV7Point0.class);
    private final IndexAdministrationService indexAdministrationService;

    @Autowired
    public UpgradeTaskV7Point0(IndexAdministrationService indexAdministrationService) {
        this.indexAdministrationService = indexAdministrationService;
    }

    @Override
    public void execute(@Nonnull SearchClient client) throws IndexException {
        ArrayList errors = new ArrayList();
        UpdateMappingRequest repositoryMappingUpdateRequest = new UpdateMappingRequest.Builder(RepositoryMapping.type()).withField(RepositoryMapping.ARCHIVED, (FieldBuilder)ES.booleanField()).build();
        UpdateMappingRequest indexStateMappingUpdateRequest = new UpdateMappingRequest.Builder(IndexStateMapping.type()).withField(IndexStateMapping.ARCHIVED, (FieldBuilder)ES.booleanField()).build();
        UpdateMappingRequest fileMappingUpdateRequest = new UpdateMappingRequest.Builder(FileMapping.type()).withField(FileMapping.ARCHIVED, (FieldBuilder)ES.booleanField()).build();
        Observables.consume(this.indexAdministrationService.updateMapping(repositoryMappingUpdateRequest).mergeWith(this.indexAdministrationService.updateMapping(indexStateMappingUpdateRequest)).mergeWith(this.indexAdministrationService.updateMapping(fileMappingUpdateRequest)), e -> {
            log.error("Failed to update index", e);
            errors.add(e.getMessage());
        }, response -> {
            if (!response.isStatusSuccess()) {
                response.getErrorType().ifPresent(errors::add);
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to update indexes: ''{}''", errors);
            throw new IndexException("Failed to update index: " + String.valueOf(errors));
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Update repository, file and index state mapping";
    }

    @Override
    @Nonnull
    public Version getVersion() {
        return IndexVersions.VERSION_7;
    }
}

