/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.upgrade;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.IndexStateMapping;
import com.atlassian.bitbucket.internal.search.indexing.administration.IndexAdministrationService;
import com.atlassian.bitbucket.internal.search.indexing.administration.UpdateMappingRequest;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.IndexVersions;
import com.atlassian.bitbucket.internal.search.indexing.upgrade.UpgradeTask;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.indices.FieldBuilder;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpgradeTaskV8Point0
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTaskV8Point0.class);
    private final IndexAdministrationService indexAdministrationService;

    @Autowired
    public UpgradeTaskV8Point0(IndexAdministrationService indexAdministrationService) {
        this.indexAdministrationService = indexAdministrationService;
    }

    @Override
    public void execute(@Nonnull SearchClient client) throws Exception {
        ArrayList errors = new ArrayList();
        UpdateMappingRequest indexStateMappingUpdateRequest = new UpdateMappingRequest.Builder(IndexStateMapping.type()).withField(IndexStateMapping.INDEXED_TIMESTAMP, (FieldBuilder)ES.longField()).withField(IndexStateMapping.INDEXING_ERROR, (FieldBuilder)ES.textField().index(false)).build();
        Observables.consume(this.indexAdministrationService.updateMapping(indexStateMappingUpdateRequest), e -> {
            log.error("Failed to update index", e);
            errors.add(e.getMessage());
        }, response -> {
            if (!response.isStatusSuccess()) {
                response.getErrorType().ifPresent(errors::add);
            }
        });
        if (!errors.isEmpty()) {
            log.error("Failed to update indexes: ''{}''", errors);
            throw new IndexException("Failed to update index: " + String.valueOf(errors));
        }
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "Add indexedTimestamp attribute to index state default mapping";
    }

    @Override
    @Nonnull
    public Version getVersion() {
        return IndexVersions.VERSION_8;
    }
}

