/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.util;

import com.atlassian.bitbucket.internal.search.client.Requests;
import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.common.mapping.MappingType;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.IndexException;
import com.atlassian.bitbucket.internal.search.indexing.util.Observables;
import com.atlassian.elasticsearch.client.ES;
import com.atlassian.elasticsearch.client.search.Hit;
import com.atlassian.elasticsearch.client.search.ScrollGetRequestBuilder;
import com.atlassian.elasticsearch.client.search.SearchRequestBuilder;
import com.atlassian.elasticsearch.client.search.SearchSourceBuilder;
import io.atlassian.fugue.Either;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;

public class ElderScroll {
    private static final Logger log = LoggerFactory.getLogger(ElderScroll.class);
    private final SearchClient searchClient;

    public ElderScroll(@Nonnull SearchClient searchClient) {
        this.searchClient = Objects.requireNonNull(searchClient, "searchClient");
    }

    public Observable<Hit> search(@Nonnull SearchSourceBuilder searchSource, @Nonnull MappingType mappingType, @Nonnull Duration scrollIdLifetime) {
        return Observable.create(subscriber -> new ScrollProducer(Objects.requireNonNull(searchSource, "searchSource"), Objects.requireNonNull(mappingType, "mappingType"), Objects.requireNonNull(scrollIdLifetime, "scrollIdLifetime")).call((Subscriber<? super Hit>)subscriber));
    }

    private class ScrollProducer
    implements Observable.OnSubscribe<Hit> {
        private final MappingType mappingType;
        private final Duration scrollIdLifetime;
        private final SearchSourceBuilder searchSource;
        private long fetchedItemCount;
        private String scrollId;
        private long totalItemCount = Long.MAX_VALUE;

        ScrollProducer(SearchSourceBuilder searchSource, MappingType mappingType, Duration scrollIdLifetime) {
            this.searchSource = searchSource;
            this.mappingType = mappingType;
            this.scrollIdLifetime = scrollIdLifetime;
        }

        public void call(Subscriber<? super Hit> subscriber) {
            try {
                while (!subscriber.isUnsubscribed() && this.fetchedItemCount < this.totalItemCount) {
                    this.fetchMore(subscriber);
                }
            }
            catch (Exception ex) {
                subscriber.onError((Throwable)ex);
            }
            finally {
                this.deleteScrollToken();
            }
        }

        private void deleteScrollToken() {
            Either result;
            if (this.scrollId != null && ((Boolean)(result = Observables.consumeSingle(ElderScroll.this.searchClient.execute(ES.scroll().delete().id(this.scrollId)))).fold(e -> true, rs -> !rs.isStatusSuccess())).booleanValue()) {
                log.warn("Unable to remove the scroll token previously reserved. This is not strictly speaking a serious error, but has resource utilisation consequences for the search server. And should therefore not be allowed to happen often.");
            }
            this.scrollId = null;
        }

        private void fetchMore(Subscriber<? super Hit> subscriber) {
            Observable scrollResponse;
            if (this.scrollId == null) {
                SearchRequestBuilder searchRequestBuilder = Requests.request(this.mappingType).search().source(this.searchSource).scroll(this.scrollIdLifetime);
                Observable searchRs = ElderScroll.this.searchClient.execute(searchRequestBuilder);
                scrollResponse = searchRs.map(rs -> {
                    if (rs.isStatusSuccess()) {
                        this.totalItemCount = rs.getTotalHitsNumber();
                        List hits = rs.getHits();
                        this.scrollId = rs.getScrollId().orElse(null);
                        if (this.totalItemCount > (long)hits.size() && this.scrollId == null) {
                            throw new IndexException("No scrollId returned from search with scroll request and multiple pages");
                        }
                        return hits;
                    }
                    throw new IndexException("The request to the search server failed with HTTP status code: " + rs.getStatusCode());
                });
            } else {
                ScrollGetRequestBuilder scrollGetRequestBuilder = ES.scroll().get().id(this.scrollId).scroll(this.scrollIdLifetime);
                Observable scrollRs = ElderScroll.this.searchClient.execute(scrollGetRequestBuilder);
                scrollResponse = scrollRs.map(rs -> {
                    if (rs.isStatusSuccess()) {
                        this.scrollId = (String)rs.getScrollId().orElseThrow(() -> new IndexException("Scroll response did not contain a scrollId: " + this.scrollId));
                        return rs.getHits();
                    }
                    throw new IndexException("The request to the search server failed with HTTP status code: " + rs.getStatusCode());
                });
            }
            Observables.consume(scrollResponse.defaultIfEmpty(Collections.emptyList()), arg_0 -> subscriber.onError(arg_0), hits -> {
                if (hits.size() == 0) {
                    subscriber.onCompleted();
                } else {
                    hits.forEach(arg_0 -> ((Subscriber)subscriber).onNext(arg_0));
                    this.fetchedItemCount += (long)hits.size();
                    if (this.fetchedItemCount >= this.totalItemCount) {
                        subscriber.onCompleted();
                    }
                }
            });
        }
    }
}

