/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.util;

import io.atlassian.fugue.Either;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import rx.Observable;

public class Observables {
    private Observables() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " only contains static utility methods and should not be instantiated.");
    }

    public static <V> void consume(Observable<V> observable, Consumer<Throwable> onError, Consumer<V> onSuccess) {
        CountDownLatch latch = new CountDownLatch(1);
        observable.subscribe(onSuccess::accept, error -> {
            onError.accept((Throwable)error);
            latch.countDown();
        }, latch::countDown);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            onError.accept(e);
        }
    }

    public static <V> void consume(Observable<V> observable, Consumer<Throwable> onError, Consumer<V> onSuccess, Runnable onComplete) {
        CountDownLatch latch = new CountDownLatch(1);
        observable.subscribe(onSuccess::accept, error -> {
            onError.accept((Throwable)error);
            latch.countDown();
        }, () -> {
            latch.countDown();
            onComplete.run();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            onError.accept(e);
        }
    }

    public static <V> Either<Exception, V> consumeSingle(Observable<V> observable) {
        AtomicReference result = new AtomicReference();
        Observables.consume(observable.take(1), error -> {
            if (!(error instanceof Exception)) {
                throw (Error)error;
            }
            result.set(Either.left((Object)((Exception)error)));
        }, successResult -> result.set(Either.right((Object)successResult)), () -> {
            if (result.get() == null) {
                result.set(Either.left((Object)new IllegalStateException("consumeSingle was called on an empty Observable")));
            }
        });
        return (Either)result.get();
    }
}

