/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.indexing.util;

import com.atlassian.bitbucket.internal.search.client.SearchClient;
import com.atlassian.bitbucket.internal.search.indexing.exceptions.ServiceUnavailableException;
import com.atlassian.elasticsearch.client.request.RequestBuilder;
import com.atlassian.elasticsearch.client.request.Response;
import java.net.ConnectException;
import rx.Observable;

public class SearchUtil {
    public static <T extends Response> Observable<T> executeHandleUnavailable(SearchClient client, RequestBuilder<T> requestBuilder) {
        return client.execute(requestBuilder).flatMap(response -> response.getStatusCode() == 503 ? Observable.error((Throwable)new ServiceUnavailableException("The search server returned 503 (service unavailable) for the request")) : Observable.just((Object)response));
    }

    public static boolean isNetworkConnectException(Throwable t) {
        for (int depth = 0; t != null && depth < 3; t = t.getCause(), ++depth) {
            if (!(t instanceof ConnectException)) continue;
            return true;
        }
        return false;
    }
}

