/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.search.search;

import com.atlassian.bitbucket.internal.search.search.Pageable;
import java.util.Objects;

public abstract class AbstractPageable<B extends Builder<B>>
implements Pageable {
    private final boolean isLastPage;
    private final int offset;
    private final int pageNumber;
    private final int pageSize;

    protected AbstractPageable(Builder<B> builder) {
        this.isLastPage = builder.isLastPage;
        this.offset = builder.offset;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractPageable)) {
            return false;
        }
        AbstractPageable that = (AbstractPageable)o;
        return this.isLastPage == that.isLastPage && this.offset == that.offset && this.pageNumber == that.pageNumber && this.pageSize == that.pageSize;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    public int hashCode() {
        return Objects.hash(this.isLastPage, this.offset, this.pageNumber, this.pageSize);
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    public String toString() {
        return "AbstractPageable{isLastPage=" + this.isLastPage + ", offset=" + this.offset + ", pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + "}";
    }

    public static abstract class Builder<B> {
        private boolean isLastPage;
        private int offset;
        private int pageNumber;
        private int pageSize;

        public B isLastPage(boolean isLastPage) {
            this.isLastPage = isLastPage;
            return this.self();
        }

        public B offset(int offset) {
            this.offset = offset;
            return this.self();
        }

        public B pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this.self();
        }

        public B pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this.self();
        }

        protected abstract B self();
    }
}

